package cn.ipokerface.admin.spring.web;

import cn.ipokerface.admin.Constant;
import cn.ipokerface.admin.ResultCode;
import cn.ipokerface.admin.body.AccessModel;
import cn.ipokerface.admin.cache.AdminCacheService;
import cn.ipokerface.web.interceptor.AbstractInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by       PokerFace
 * Create Date      2020-05-25.
 * Email:
 * Version          1.0.0
 *
 * Description:
 */


@Component
public class AccessInterceptor extends AbstractInterceptor {

    private static Logger logger = LoggerFactory.getLogger(AccessInterceptor.class);


    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private InterceptorProperties interceptorProperties;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        // 是否是需要验证的
        if (!(handler instanceof HandlerMethod)) return true;


        AccessModel accessModel = (AccessModel) request.getAttribute(Constant.REQUEST_ATTRIBUTE_ACCESS);
        if (accessModel == null) {
            responseJson(response, ResultCode.CODE_ADMIN_ACCESS_INVALID);
            return false;
        }
        if (AdminCacheService.ACCESS_OCCUPIED_TOKEN.equals(accessModel.getAccessToken())) {
            responseJson(response, ResultCode.CODE_ADMIN_ACCESS_INVALID);
            return false;
        }
        long expiredTimestamp = interceptorProperties.getAccessExpiredTimestamp();
        if ((System.currentTimeMillis() - accessModel.getAccessTimestamp()) >= expiredTimestamp) {
            responseJson(response, ResultCode.CODE_ADMIN_ACCESS_EXPIRED);
            return false;
        }

        accessModel.setAccessTimestamp(System.currentTimeMillis());
        accessModel.setExpiredTimestamp(accessModel.getAccessTimestamp() + expiredTimestamp);

        // refresh access token
        adminCacheService.setAccess(accessModel);

        return true;
    }

}
