package cn.ipokerface.admin.spring.web;

import cn.ipokerface.admin.Constant;
import cn.ipokerface.admin.body.AccessModel;
import cn.ipokerface.admin.cache.AdminCacheService;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.web.interceptor.AbstractInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by       PokerFace
 * Create Date      2021/7/19
 * Version          1.0.0
 * Description:
 */



@Component
public class AccessAttributeInterceptor extends AbstractInterceptor {


    private static Logger logger = LoggerFactory.getLogger(AccessInterceptor.class);


    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private InterceptorProperties interceptorProperties;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String token = request.getHeader(Constant.HTTP_HEADER_ACCESS_TOKEN);
        if (!StringUtils.isEmpty(token)) {
            AccessModel accessModel = adminCacheService.getAccess(token);
            if (accessModel != null ) {
                request.setAttribute(Constant.REQUEST_ATTRIBUTE_ACCESS, accessModel);
            }
        }

        return true;
    }
}
