package cn.ipokerface.admin.spring.api;

import cn.ipokerface.admin.ResultCode;
import cn.ipokerface.admin.exception.*;
import cn.ipokerface.common.exception.ServiceException;
import cn.ipokerface.common.model.api.ResultBody;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by       mac
 * Create Date      2020/12/12
 * Version          1.0.0
 * Description:
 */



@Order(Integer.MAX_VALUE - 2)
@Configuration
@ControllerAdvice
public class ControllerExceptionHandler extends cn.ipokerface.web.controller.ControllerExceptionHandler {


    @ResponseBody
    @ExceptionHandler(value = {ServiceException.class})
    public ResultBody exceptionHandler(ServiceException ex) {
        if ( ex instanceof PasswordWrongException) {
            error(ex);
            return ResultCode.CODE_ADMIN_ACCOUNT_PASSWORD_WRONG;
        } else if (ex instanceof PasswordRequireException) {
            error(ex);
            return ResultCode.CODE_ADMIN_ACCOUNT_PASSWORD_REQUIRED;
        } else if (ex instanceof AccountWrongException) {
            error(ex);
            return ResultCode.CODE_ADMIN_ACCOUNT_WRONG;
        } else if (ex instanceof AccountExistException){
            error(ex);
            return ResultCode.CODE_ADMIN_ACCOUNT_EXIST;
        } else if (ex instanceof AccountForbiddenException){
            error(ex);
            return ResultCode.CODE_ADMIN_ACCOUNT_FORBIDDEN;
        }else {
            // 未处理的交给父类处理
            return super.exceptionHandler(ex);
        }
    }
}
