package cn.ipokerface.admin.spring;

import cn.ipokerface.admin.spring.admin.AdminCacheProperties;
import cn.ipokerface.admin.spring.admin.AdminProperties;
import cn.ipokerface.admin.authority.AuthorityRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2021/7/19
 * Version          1.0.0
 * Description:
 */


@ComponentScan({"cn.ipokerface.admin.service"})
@Configuration
@EnableConfigurationProperties({AdminProperties.class, AdminCacheProperties.class})
public class AdminAutoConfiguration {


    @Bean
    @ConditionalOnMissingBean(AuthorityRepository.class)
    public AuthorityRepository authorityRepository(){
        return new AuthorityRepository() {
            @Override
            public List<String> authorities() {
                return new ArrayList<>();
            }
        };
    }


}
