package cn.ipokerface.admin.controller;

import cn.ipokerface.admin.Constant;
import cn.ipokerface.admin.annontation.RequiredAuthorization;
import cn.ipokerface.admin.body.ConfigurationBody;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.property.PropertyResource;
import cn.ipokerface.property.spring.PropertyResourceRedisService;
import cn.ipokerface.web.controller.BaseController;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2020-07-30.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@RestController
@RequestMapping("/api/admin/config")
public class ConfigurationController extends BaseController {


    @Autowired
    private PropertyResourceRedisService propertyResourceRedisService;

    @RequiredAuthorization(code = Constant.CODE_ADMIN_CONFIG)
    @RequestMapping("/all")
    public ResultBody properties() {
        Map<String, PropertyResource> propertyModelMap = propertyResourceRedisService.getProperties();

        return ResultBody.builder()
                .data(new ConfigurationBody(propertyModelMap))
                .build();
    }


    /**
     * properties 参数配置的json数据
     *
     * @param properties properties
     * @return ResultBody
     */
    @RequiredAuthorization(code = Constant.CODE_ADMIN_CONFIG_UPDATE)
    @RequestMapping(value = "/config", method = RequestMethod.POST)
    public ResultBody propertiesConfig(String properties) {
        List<PropertyResource> configModels = JSON.parseArray(properties, PropertyResource.class);
        propertyResourceRedisService.setProperties(configModels);
        return ResultBody.builder()
                .build();
    }








}

