package cn.ipokerface.admin.controller;


import cn.ipokerface.admin.Constant;
import cn.ipokerface.admin.body.AccessModel;
import cn.ipokerface.admin.body.AccountModel;
import cn.ipokerface.admin.cache.AdminCacheService;
import cn.ipokerface.admin.entity.AdminAccount;
import cn.ipokerface.admin.exception.PasswordWrongException;
import cn.ipokerface.admin.param.LoginParam;
import cn.ipokerface.admin.service.AdminAccountService;
import cn.ipokerface.admin.spring.admin.AdminProperties;
import cn.ipokerface.admin.spring.web.InterceptorProperties;
import cn.ipokerface.common.model.BaseListModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.DigestUtils;
import cn.ipokerface.web.controller.BaseController;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-26.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */

@RestController
@RequestMapping("/api/admin")
public class AdminController extends BaseController {


    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private AdminProperties adminProperties;
    @Autowired
    private InterceptorProperties interceptorProperties;
    @Autowired
    private AdminAccountService adminAccountService;



    @RequestMapping(value = "/login", method = RequestMethod.POST)
    public ResultBody login(@Validated LoginParam param, HttpServletRequest request) {
        String ip = getClientIpAddress(request);

        AdminAccount adminAccount = null;
        if (adminProperties.getSuperAdminUsername().equals(param.getUsername())) {
            // 超级管理员
            if(!param.getPassword().equals(DigestUtils.md5Hex(adminProperties.getSuperAdminPassword())))
            {
                throw new PasswordWrongException();
            }
            adminAccount = new AdminAccount();
            adminAccount.setId(adminProperties.getSuperAdminId());
            adminAccount.setUsername(adminProperties.getSuperAdminUsername());
            adminAccount.setName(adminProperties.getSuperAdminName());

        } else {
            adminAccount = adminAccountService.login(param.getUsername(), param.getPassword());
        }

        AccountModel accountModel = new AccountModel();
        BeanUtils.copyProperties(adminAccount, accountModel);

        AccessModel accessModel = new AccessModel();
        accessModel.setAccessToken(DigestUtils.md5Hex(adminAccount.getUsername() + System.currentTimeMillis()));
        accessModel.setAccountId(adminAccount.getId());
        accessModel.setAccessTimestamp(System.currentTimeMillis());
        accessModel.setExpiredTimestamp(accessModel.getAccessTimestamp() + interceptorProperties.getAccessExpiredTimestamp());

        adminCacheService.setAccess(accessModel);
        adminCacheService.setAccount(accountModel);

        return ResultBody.builder()
                .data(accessModel)
                .build();
    }



    @RequestMapping(value = "/logout", method = RequestMethod.POST)
    public ResultBody logout(@RequestHeader(Constant.HTTP_HEADER_ACCESS_TOKEN) String token ) {

        adminCacheService.removeAccess(token);

        return ResultBody.builder()
                .build();
    }

    @RequestMapping(value = "/account")
    public ResultBody account(@RequestHeader(Constant.HTTP_HEADER_ACCESS_TOKEN) String token) throws Exception{

        return ResultBody.builder()
                .data(adminCacheService.getAccount(token))
                .build();

    }


    @RequestMapping(value = "/authorities")
    public ResultBody authorities(@RequestAttribute(Constant.REQUEST_ATTRIBUTE_ACCESS)AccessModel accessModel) throws Exception{
        List<String> authorityModelList = adminCacheService.getRoleAuthorities(adminCacheService.getAccountRoles(accessModel.getAccountId()));
        return ResultBody.builder()
                .data(new BaseListModel(authorityModelList))
                .build();
    }


    @RequestMapping(value = "/password", method = RequestMethod.POST)
    public ResultBody password(@RequestAttribute(Constant.REQUEST_ATTRIBUTE_ACCESS)AccessModel accessModel,
                             String password,String newPassword) throws Exception
    {
        adminAccountService.resetPassword(accessModel.getAccountId(),password, newPassword);

        return ResultBody.builder()
                .build();
    }

}
