package cn.ipokerface.admin.cache;

import cn.ipokerface.admin.body.AccessModel;
import cn.ipokerface.admin.body.AccountModel;
import cn.ipokerface.admin.spring.admin.AdminCacheProperties;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.redis.JedisClient;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Created by       mac
 * Create Date      2020/12/12
 * Version          1.0.0
 * Description:
 */

@Service
public class AdminCacheServiceRedis implements AdminCacheService{


    public static final String KEY_ADMIN_ACCOUNT_ID_MODEL_MAP               = ":ACCOUNT_ID_MODEL_MAP";
    public static final String KEY_ADMIN_TOKEN_ACCESS_MAP                   = ":TOKEN_ACCESS_MAP";
    public static final String KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP              = ":ACCOUNT_ID_ACCESS_MAP";

    public static final String KEY_ADMIN_AUTHORITY_ID_MAP                   = ":AUTHORITY_ID_MAP";
    public static final String KEY_ADMIN_ROLE_AUTHORITY_MAP                 = ":ROLE_AUTHORITY_MAP";
    public static final String KEY_ADMIN_ACCOUNT_ROLE_MAP                   = ":ADMIN_ACCOUNT_ROLE_MAP";


    @Autowired
    private JedisClient jedisClient;
    @Autowired
    private AdminCacheProperties adminCacheProperties;

    @Override
    public void setAccount(AccountModel account) {
        if (account == null || account.getId() == null) return;
        jedisClient.hset(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_ACCOUNT_ID_MODEL_MAP, account.getId().toString(), account.toJsonString());
    }

    @Override
    public AccountModel getAccount(Long accountId) {
        if (accountId == null) return null;
        String result = jedisClient.hget(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_ACCOUNT_ID_MODEL_MAP, accountId.toString());
        return StringUtils.isEmpty(result)?null:JSON.parseObject(result, AccountModel.class);
    }

    @Override
    public AccountModel getAccount(String accessToken) {
        AccessModel accessModel = getAccess(accessToken);
        if (accessModel == null) return null;
        return getAccount(accessModel.getAccountId());
    }

    @Override
    public void setAccess(AccessModel accessModel) {
        String result = jedisClient.hget(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP, accessModel.getAccountId().toString());
        if (!StringUtils.isEmpty(result)) {
            AccessModel oldAccess = JSON.parseObject(result, AccessModel.class);
            // 不是当前access
            if (oldAccess != null && !oldAccess.getAccessToken().equals(accessModel.getAccessToken())) {
                String accessToken = oldAccess.getAccessToken();
                oldAccess.setAccessToken(ACCESS_OCCUPIED_TOKEN);
                oldAccess.setAccountId(ACCESS_OCCUPIED_ID);
                jedisClient.hset(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_TOKEN_ACCESS_MAP, accessToken, oldAccess.toJsonString());
            }
        }
        jedisClient.hset(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_TOKEN_ACCESS_MAP, accessModel.getAccessToken(), accessModel.toJsonString());
        jedisClient.hset(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP, accessModel.getAccountId().toString(), accessModel.toJsonString());
    }

    @Override
    public void removeAccess(String accessToken) {
        jedisClient.hdel(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_TOKEN_ACCESS_MAP, accessToken);
    }

    @Override
    public AccessModel getAccess(String accessToken) {
        String result = jedisClient.hget(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_TOKEN_ACCESS_MAP, accessToken);
        return StringUtils.isEmpty(result)?null:JSON.parseObject(result, AccessModel.class);
    }

    @Override
    public AccessModel getAccess(Long accountId) {
        if (accountId == null) return null;
        String result = jedisClient.hget(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP, accountId.toString());
        return StringUtils.isEmpty(result)?null:JSON.parseObject(result, AccessModel.class);
    }





    /**
     * 更新 角色-》权限列表
     *
     * @param roleId roleId
     * @param authorityIds authorityIds
     */
    @Override
    public void setRoleAuthorities(Long roleId, List<String> authorityIds){
        if (roleId == null ) return;
        if ( authorityIds == null) authorityIds = new ArrayList<>();
        jedisClient.hset(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_ROLE_AUTHORITY_MAP, roleId.toString(), JSON.toJSONString(authorityIds));
    }


    /**
     *  更新用户角色
     *
     * @param accountId accountId
     * @param roleIds roleIds
     */
    @Override
    public void setAccountRoles(Long accountId, List<Long> roleIds){
        if (accountId == null) return;
        if ( roleIds == null) roleIds = new ArrayList<>();
        jedisClient.hset(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_ACCOUNT_ROLE_MAP, accountId.toString(), JSON.toJSONString(roleIds));
    }


    @Override
    public List<Long> getAccountRoles(Long accountId) {
        String roleString = jedisClient.hget(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_ACCOUNT_ROLE_MAP, accountId.toString());
        return StringUtils.isEmpty(roleString) ? null : JSON.parseArray(roleString, Long.class);
    }

    @Override
    public List<String> getRoleAuthorities(List<Long> roleIds) {
        if (CollectionUtils.isEmpty(roleIds)) return null;
        Set<String> set = new HashSet<>();
        String[] arr = new String[roleIds.size()];
        for(int i=0;i< arr.length;i++) {
            arr[i] = String.valueOf(roleIds.get(i));
        }
        List<String> result = jedisClient.hmget(adminCacheProperties.getKeyPrefix()+KEY_ADMIN_ROLE_AUTHORITY_MAP, arr);
        if (CollectionUtils.isNotEmpty(result)) {
            result.stream().forEach((item)->{
                List<String> list = JSON.parseArray(item, String.class);
                if (CollectionUtils.isNotEmpty(list)) {
                    set.addAll(list);
                }
            });
        }
        return new ArrayList<>(set);
    }



}
