package cn.ipokerface.admin.cache;


import cn.ipokerface.admin.body.AccessModel;
import cn.ipokerface.admin.body.AccountModel;

import java.util.List;

/**
 * Created by       mac
 * Create Date      2020/12/12
 * Version          1.0.0
 * Description:
 */
public interface AdminCacheService{


    public static final String ACCESS_OCCUPIED_TOKEN                = "OCCUPIED";
    public static final Long ACCESS_OCCUPIED_ID                     = -1L;

    /**
     *  更新账号数据
     *
     * @param account acount
     */
    void setAccount(AccountModel account);
    AccountModel getAccount(Long accountId);
    AccountModel getAccount(String accessToken);


    /**
     *  更新一个账号的access信息 如果以前有登录信息，则会将accessToken 设置为
     *  {@link AdminCacheService#ACCESS_OCCUPIED_TOKEN}
     *
     * @param accessModel accessModel
     */
    void setAccess(AccessModel accessModel);
    void removeAccess(String accessToken);
    AccessModel getAccess(String accessToken);
    AccessModel getAccess(Long accountId);


    void setRoleAuthorities(Long roleId, List<String> authorities);
    List<String> getRoleAuthorities(List<Long> roleIds);


    void setAccountRoles(Long accountId, List<Long> roleIds);
    List<Long> getAccountRoles(Long accountId);

}
