package cn.ipokerface.admin.authority;

import cn.ipokerface.admin.Constant;
import cn.ipokerface.admin.cache.AdminCacheService;
import cn.ipokerface.admin.spring.admin.AdminProperties;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2021/7/19
 * Version          1.0.0
 * Description:
 */

@Configuration
public class AuthorityInitializingBean implements InitializingBean {


    @Autowired
    private AuthorityRepository authorityRepository;
    @Autowired
    private AdminCacheService adminCacheService;

    @Autowired
    private AdminProperties adminProperties;

    @Override
    public void afterPropertiesSet() throws Exception {

        List<String> authorities = authorityRepository.authorities();
        if (CollectionUtils.isEmpty(authorities)) {
            authorities = new ArrayList<>();
        }

        authorities.add(Constant.CODE_ADMIN);
        authorities.add(Constant.CODE_ADMIN_ACCOUNT);
        authorities.add(Constant.CODE_ADMIN_ACCOUNT_QUERY);
        authorities.add(Constant.CODE_ADMIN_ACCOUNT_ADD);
        authorities.add(Constant.CODE_ADMIN_ACCOUNT_REMOVE);
        authorities.add(Constant.CODE_ADMIN_ACCOUNT_FORBIDDEN);
        authorities.add(Constant.CODE_ADMIN_ACCOUNT_NORMALIZE);
        authorities.add(Constant.CODE_ADMIN_ACCOUNT_RESET);
        authorities.add(Constant.CODE_ADMIN_ACCOUNT_UPDATE);
        authorities.add(Constant.CODE_ADMIN_ACCOUNT_ROLE);
        authorities.add(Constant.CODE_ADMIN_ROLE);
        authorities.add(Constant.CODE_ADMIN_ROLE_QUERY);
        authorities.add(Constant.CODE_ADMIN_ROLE_ADD);
        authorities.add(Constant.CODE_ADMIN_ROLE_REMOVE);
        authorities.add(Constant.CODE_ADMIN_ROLE_UPDATE);
        authorities.add(Constant.CODE_ADMIN_ROLE_AUTH);
        authorities.add(Constant.CODE_ADMIN_CONFIG);
        authorities.add(Constant.CODE_ADMIN_CONFIG_QUERY);
        authorities.add(Constant.CODE_ADMIN_CONFIG_UPDATE);

//        adminCacheService.setAuthorities(authorities);

        adminCacheService.setRoleAuthorities(adminProperties.getSuperAdminRoleId(),authorities);
        adminCacheService.setAccountRoles(adminProperties.getSuperAdminId(), Arrays.asList(adminProperties.getSuperAdminRoleId()));
    }
}
