package cn.ipokerface.admin;

import cn.ipokerface.admin.model.AccessModel;
import cn.ipokerface.admin.model.AccountModel;
import cn.ipokerface.admin.model.AuthorityModel;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.redis.JedisClient;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by       mac
 * Create Date      2020/12/12
 * Version          1.0.0
 * Description:
 */

@Service
public class AdminCacheServiceRedis implements AdminCacheService{


    public static final String KEY_ADMIN_ACCOUNT_ID_MODEL_MAP               = "ADMIN:ACCOUNT_ID_MODEL_MAP";
    public static final String KEY_ADMIN_TOKEN_ACCESS_MAP                   = "ADMIN:TOKEN_ACCESS_MAP";
    public static final String KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP              = "ADMIN:ACCOUNT_ID_ACCESS_MAP";

    public static final String KEY_ADMIN_AUTHORITY_ID_MAP                   = "ADMIN:AUTHORITY_ID_MAP";
    public static final String KEY_ADMIN_ROLE_AUTHORITY_MAP                 = "ADMIN:ROLE_AUTHORITY_MAP";
    public static final String KEY_ADMIN_ACCOUNT_ROLE_MAP                   = "ADMIN_ACCOUNT_ROLE_MAP";


    @Autowired
    private JedisClient jedisClient;

    @Override
    public void setAccount(AccountModel account) {
        if (account == null || account.getId() == null) return;
        jedisClient.hset(KEY_ADMIN_ACCOUNT_ID_MODEL_MAP, account.getId().toString(), account.toJsonString());
    }

    @Override
    public AccountModel getAccount(Long accountId) {
        if (accountId == null) return null;
        String result = jedisClient.hget(KEY_ADMIN_ACCOUNT_ID_MODEL_MAP, accountId.toString());
        return StringUtils.isEmpty(result)?null:JSON.parseObject(result, AccountModel.class);
    }

    @Override
    public AccountModel getAccount(String accessToken) {
        AccessModel accessModel = getAccess(accessToken);
        if (accessModel == null) return null;
        return getAccount(accessModel.getAccountId());
    }

    @Override
    public void setAccess(AccessModel accessModel) {
        String result = jedisClient.hget(KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP, accessModel.getAccountId().toString());
        if (!StringUtils.isEmpty(result)) {
            AccessModel oldAccess = JSON.parseObject(result, AccessModel.class);
            // 不是当前access
            if (oldAccess != null && !oldAccess.getAccessToken().equals(accessModel.getAccessToken())) {
                String accessToken = oldAccess.getAccessToken();
                oldAccess.setAccessToken(ACCESS_OCCUPIED_TOKEN);
                oldAccess.setAccountId(ACCESS_OCCUPIED_ID);
                jedisClient.hset(KEY_ADMIN_TOKEN_ACCESS_MAP, accessToken, oldAccess.toJsonString());
            }
        }
        jedisClient.hset(KEY_ADMIN_TOKEN_ACCESS_MAP, accessModel.getAccessToken(), accessModel.toJsonString());
        jedisClient.hset(KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP, accessModel.getAccountId().toString(), accessModel.toJsonString());
    }

    @Override
    public void removeAccess(String accessToken) {
        jedisClient.hdel(KEY_ADMIN_TOKEN_ACCESS_MAP, accessToken);
    }

    @Override
    public AccessModel getAccess(String accessToken) {
        String result = jedisClient.hget(KEY_ADMIN_TOKEN_ACCESS_MAP, accessToken);
        return StringUtils.isEmpty(result)?null:JSON.parseObject(result, AccessModel.class);
    }

    @Override
    public AccessModel getAccess(Long accountId) {
        if (accountId == null) return null;
        String result = jedisClient.hget(KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP, accountId.toString());
        return StringUtils.isEmpty(result)?null:JSON.parseObject(result, AccessModel.class);
    }



    /**
     * 更新key-model     id- model
     *
     * @param authorities authorities
     */
    @Override
    public void setAuthorities(List<AuthorityModel> authorities) {
        jedisClient.del(KEY_ADMIN_AUTHORITY_ID_MAP);
        if (CollectionUtils.isNotEmpty(authorities)) {
            Map<String, String> hash = new HashMap<>();
            authorities.stream().forEach((item) ->{
                hash.put(item.getId().toString(), JSON.toJSONString(item));
            });
            jedisClient.hset(KEY_ADMIN_AUTHORITY_ID_MAP, hash);
        }

    }


    @Override
    public List<AuthorityModel> getAuthorities() {
        List<AuthorityModel> authorityModels = new ArrayList<>();
        Map<String,String> authModelString = jedisClient.hgetAll(KEY_ADMIN_AUTHORITY_ID_MAP);
        if (MapUtils.isEmpty(authModelString)) return authorityModels;
        authModelString.values().stream().forEach(item -> {
            authorityModels.add(JSON.parseObject(item, AuthorityModel.class));
        });
        return authorityModels;
    }

    /**
     * 更新 角色-》权限列表
     *
     * @param roleId roleId
     * @param authorityIds authorityIds
     */
    @Override
    public void setRoleAuthorities(Long roleId, List<Long> authorityIds){
        if (roleId == null ) return;
        if ( authorityIds == null) authorityIds = new ArrayList<>();
        jedisClient.hset(KEY_ADMIN_ROLE_AUTHORITY_MAP, roleId.toString(), JSON.toJSONString(authorityIds));
    }


    /**
     *  更新用户角色
     *
     * @param accountId accountId
     * @param roleIds roleIds
     */
    @Override
    public void setAccountRoles(Long accountId, List<Long> roleIds){
        if (accountId == null) return;
        if ( roleIds == null) roleIds = new ArrayList<>();
        jedisClient.hset(KEY_ADMIN_ACCOUNT_ROLE_MAP, accountId.toString(), JSON.toJSONString(roleIds));
    }


    @Override
    public List<Long> getAccountRoles(Long accountId) {
        String roleString = jedisClient.hget(KEY_ADMIN_ACCOUNT_ROLE_MAP, accountId.toString());
        return StringUtils.isEmpty(roleString) ? null : JSON.parseArray(roleString, Long.class);
    }

    @Override
    public List<AuthorityModel> getRoleAuthorities(List<Long> roleIds) {
        List<AuthorityModel> authorityModels = new ArrayList<>();
        if (CollectionUtils.isEmpty(roleIds))  return authorityModels;
        String[] roleIdArray = new String[roleIds.size()];
        for(int i=0;i<roleIdArray.length; i++) {
            roleIdArray[i] = roleIds.get(i).toString();
        }
        List<String> authIdListString = jedisClient.hmget(KEY_ADMIN_ROLE_AUTHORITY_MAP, roleIdArray);
        Set<String> authIdSet = new HashSet<>();
        if (CollectionUtils.isEmpty(authIdListString)) return authorityModels;
        authIdListString.stream().forEach(idListString -> {
            List<String> idList = JSON.parseArray(idListString, String.class);
            if (CollectionUtils.isNotEmpty(idList)) {
                authIdSet.addAll(idList);
            }
        });
        if (CollectionUtils.isEmpty(authIdSet)) return authorityModels;
        List<String> authStrings = jedisClient.hmget(KEY_ADMIN_AUTHORITY_ID_MAP, authIdSet.toArray(new String[authIdSet.size()]));
        if (CollectionUtils.isEmpty(authStrings)) return authorityModels;
        authStrings.stream().forEach(itemString -> {
            authorityModels.add(JSON.parseObject(itemString, AuthorityModel.class));
        });
        return authorityModels;
    }


//
//    @Override
//    public List<AuthorityModel> getRoleAuthorities(Long roleId) {
//        List<AuthorityModel> authorityModels = new ArrayList<>();
//        if (roleId == null) return authorityModels;
//        String authIds = jedisClient.hget(KEY_ADMIN_ROLE_AUTHORITY_MAP, roleId.toString());
//        if (StringUtils.isEmpty(authIds)) return authorityModels;
//        List<String> authIdList = JSON.parseArray(authIds, String.class);
//        List<String> authModels = jedisClient.hmget(KEY_ADMIN_AUTHORITY_ID_MAP, authIdList.toArray(new String[authIdList.size()]));
//        if (StringUtils.isEmpty(authModels)) return authorityModels;
//        authModels.stream().forEach(str -> {
//            authorityModels.add(JSON.parseObject(str, AuthorityModel.class));
//        });
//        return authorityModels;
//    }




}
