/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin;

import cn.ipokerface.admin.ConfigurationCacheService;
import cn.ipokerface.admin.model.ConfigurationModel;
import cn.ipokerface.redis.JedisClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationCacheServiceRedis
implements ConfigurationCacheService {
    public static final String KEY_CONFIGURATION_CODE_MAP = "CONFIGURATION_CODE_MAP";
    @Autowired
    private JedisClient jedisClient;

    @Override
    public void setProperties(List<ConfigurationModel> propertyModelList) {
        this.jedisClient.del(KEY_CONFIGURATION_CODE_MAP);
        if (CollectionUtils.isNotEmpty(propertyModelList)) {
            HashMap hash = new HashMap();
            propertyModelList.stream().forEach(item -> hash.put(item.getCode(), item.toJsonString()));
            this.jedisClient.hset(KEY_CONFIGURATION_CODE_MAP, hash);
        }
    }

    @Override
    public Map<String, ConfigurationModel> getProperties() {
        HashMap<String, ConfigurationModel> properties = new HashMap<String, ConfigurationModel>();
        Map result = this.jedisClient.hgetAll(KEY_CONFIGURATION_CODE_MAP);
        if (MapUtils.isEmpty((Map)result)) {
            return properties;
        }
        result.values().stream().forEach(value -> {
            ConfigurationModel model = (ConfigurationModel)JSON.parseObject((String)value, ConfigurationModel.class);
            properties.put(model.getCode(), model);
        });
        return properties;
    }

    @Override
    public ConfigurationModel getProperty(String code) {
        String result = this.jedisClient.hget(KEY_CONFIGURATION_CODE_MAP, code);
        if (cn.ipokerface.common.utils.StringUtils.isEmpty((Object)result)) {
            return null;
        }
        return (ConfigurationModel)JSONObject.parseObject((String)result, ConfigurationModel.class);
    }

    @Override
    public Map<String, ConfigurationModel> getProperties(String ... code) {
        HashMap<String, ConfigurationModel> properties = new HashMap<String, ConfigurationModel>();
        List results = this.jedisClient.hmget(KEY_CONFIGURATION_CODE_MAP, code);
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            results.stream().forEach(result -> {
                ConfigurationModel model = (ConfigurationModel)JSON.parseObject((String)result, ConfigurationModel.class);
                if (model != null && StringUtils.isNotEmpty((CharSequence)model.getCode())) {
                    properties.put(model.getCode(), model);
                }
            });
        }
        return properties;
    }
}

