/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin;

import cn.ipokerface.admin.AdminCacheService;
import cn.ipokerface.admin.model.AccessModel;
import cn.ipokerface.admin.model.AccountModel;
import cn.ipokerface.admin.model.AuthorityModel;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.redis.JedisClient;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminCacheServiceRedis
implements AdminCacheService {
    public static final String KEY_ADMIN_ACCOUNT_ID_MODEL_MAP = "ADMIN:ACCOUNT_ID_MODEL_MAP";
    public static final String KEY_ADMIN_TOKEN_ACCESS_MAP = "ADMIN:TOKEN_ACCESS_MAP";
    public static final String KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP = "ADMIN:ACCOUNT_ID_ACCESS_MAP";
    public static final String KEY_ADMIN_AUTHORITY_ID_MAP = "ADMIN:AUTHORITY_ID_MAP";
    public static final String KEY_ADMIN_ROLE_AUTHORITY_MAP = "ADMIN:ROLE_AUTHORITY_MAP";
    public static final String KEY_ADMIN_ACCOUNT_ROLE_MAP = "ADMIN_ACCOUNT_ROLE_MAP";
    @Autowired
    private JedisClient jedisClient;

    @Override
    public void setAccount(AccountModel account) {
        if (account == null || account.getId() == null) {
            return;
        }
        this.jedisClient.hset(KEY_ADMIN_ACCOUNT_ID_MODEL_MAP, account.getId().toString(), account.toJsonString());
    }

    @Override
    public AccountModel getAccount(Long accountId) {
        if (accountId == null) {
            return null;
        }
        String result = this.jedisClient.hget(KEY_ADMIN_ACCOUNT_ID_MODEL_MAP, accountId.toString());
        return StringUtils.isEmpty((Object)result) ? null : (AccountModel)JSON.parseObject((String)result, AccountModel.class);
    }

    @Override
    public AccountModel getAccount(String accessToken) {
        AccessModel accessModel = this.getAccess(accessToken);
        if (accessModel == null) {
            return null;
        }
        return this.getAccount(accessModel.getAccountId());
    }

    @Override
    public void setAccess(AccessModel accessModel) {
        AccessModel oldAccess;
        String result = this.jedisClient.hget(KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP, accessModel.getAccountId().toString());
        if (!StringUtils.isEmpty((Object)result) && (oldAccess = (AccessModel)JSON.parseObject((String)result, AccessModel.class)) != null && !oldAccess.getAccessToken().equals(accessModel.getAccessToken())) {
            String accessToken = oldAccess.getAccessToken();
            oldAccess.setAccessToken("OCCUPIED");
            oldAccess.setAccountId(ACCESS_OCCUPIED_ID);
            this.jedisClient.hset(KEY_ADMIN_TOKEN_ACCESS_MAP, accessToken, oldAccess.toJsonString());
        }
        this.jedisClient.hset(KEY_ADMIN_TOKEN_ACCESS_MAP, accessModel.getAccessToken(), accessModel.toJsonString());
        this.jedisClient.hset(KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP, accessModel.getAccountId().toString(), accessModel.toJsonString());
    }

    @Override
    public void removeAccess(String accessToken) {
        this.jedisClient.hdel(KEY_ADMIN_TOKEN_ACCESS_MAP, new String[]{accessToken});
    }

    @Override
    public AccessModel getAccess(String accessToken) {
        String result = this.jedisClient.hget(KEY_ADMIN_TOKEN_ACCESS_MAP, accessToken);
        return StringUtils.isEmpty((Object)result) ? null : (AccessModel)JSON.parseObject((String)result, AccessModel.class);
    }

    @Override
    public AccessModel getAccess(Long accountId) {
        if (accountId == null) {
            return null;
        }
        String result = this.jedisClient.hget(KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP, accountId.toString());
        return StringUtils.isEmpty((Object)result) ? null : (AccessModel)JSON.parseObject((String)result, AccessModel.class);
    }

    @Override
    public void setAuthorities(List<AuthorityModel> authorities) {
        this.jedisClient.del(KEY_ADMIN_AUTHORITY_ID_MAP);
        if (CollectionUtils.isNotEmpty(authorities)) {
            HashMap hash = new HashMap();
            authorities.stream().forEach(item -> hash.put(item.getId().toString(), JSON.toJSONString((Object)item)));
            this.jedisClient.hset(KEY_ADMIN_AUTHORITY_ID_MAP, hash);
        }
    }

    @Override
    public List<AuthorityModel> getAuthorities() {
        ArrayList<AuthorityModel> authorityModels = new ArrayList<AuthorityModel>();
        Map authModelString = this.jedisClient.hgetAll(KEY_ADMIN_AUTHORITY_ID_MAP);
        if (MapUtils.isEmpty((Map)authModelString)) {
            return authorityModels;
        }
        authModelString.values().stream().forEach(item -> authorityModels.add((AuthorityModel)JSON.parseObject((String)item, AuthorityModel.class)));
        return authorityModels;
    }

    @Override
    public void setRoleAuthorities(Long roleId, List<Long> authorityIds) {
        if (roleId == null) {
            return;
        }
        if (authorityIds == null) {
            authorityIds = new ArrayList<Long>();
        }
        this.jedisClient.hset(KEY_ADMIN_ROLE_AUTHORITY_MAP, roleId.toString(), JSON.toJSONString(authorityIds));
    }

    @Override
    public void setAccountRoles(Long accountId, List<Long> roleIds) {
        if (accountId == null) {
            return;
        }
        if (roleIds == null) {
            roleIds = new ArrayList<Long>();
        }
        this.jedisClient.hset(KEY_ADMIN_ACCOUNT_ROLE_MAP, accountId.toString(), JSON.toJSONString(roleIds));
    }

    @Override
    public List<Long> getAccountRoles(Long accountId) {
        String roleString = this.jedisClient.hget(KEY_ADMIN_ACCOUNT_ROLE_MAP, accountId.toString());
        return StringUtils.isEmpty((Object)roleString) ? null : JSON.parseArray((String)roleString, Long.class);
    }

    @Override
    public List<AuthorityModel> getRoleAuthorities(List<Long> roleIds) {
        ArrayList<AuthorityModel> authorityModels = new ArrayList<AuthorityModel>();
        if (CollectionUtils.isEmpty(roleIds)) {
            return authorityModels;
        }
        String[] roleIdArray = new String[roleIds.size()];
        for (int i = 0; i < roleIdArray.length; ++i) {
            roleIdArray[i] = roleIds.get(i).toString();
        }
        List authIdListString = this.jedisClient.hmget(KEY_ADMIN_ROLE_AUTHORITY_MAP, roleIdArray);
        HashSet authIdSet = new HashSet();
        if (CollectionUtils.isEmpty((Collection)authIdListString)) {
            return authorityModels;
        }
        authIdListString.stream().forEach(idListString -> {
            List idList = JSON.parseArray((String)idListString, String.class);
            if (CollectionUtils.isNotEmpty((Collection)idList)) {
                authIdSet.addAll(idList);
            }
        });
        if (CollectionUtils.isEmpty(authIdSet)) {
            return authorityModels;
        }
        List authStrings = this.jedisClient.hmget(KEY_ADMIN_AUTHORITY_ID_MAP, authIdSet.toArray(new String[authIdSet.size()]));
        if (CollectionUtils.isEmpty((Collection)authStrings)) {
            return authorityModels;
        }
        authStrings.stream().forEach(itemString -> authorityModels.add((AuthorityModel)JSON.parseObject((String)itemString, AuthorityModel.class)));
        return authorityModels;
    }
}

