package cn.ipokerface.admin;

import cn.ipokerface.admin.model.ConfigurationModel;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.redis.JedisClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2021/4/11.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */

@Service
public class ConfigurationCacheServiceRedis implements ConfigurationCacheService {

    public static final String KEY_CONFIGURATION_CODE_MAP   ="CONFIGURATION_CODE_MAP";

    @Autowired
    private JedisClient jedisClient;


    @Override
    public void setProperties(List<ConfigurationModel> propertyModelList) {
        jedisClient.del(KEY_CONFIGURATION_CODE_MAP);
        if (CollectionUtils.isNotEmpty(propertyModelList)) {

            Map<String,String> hash = new HashMap<>();
            propertyModelList.stream().forEach(item -> {
                hash.put(item.getCode(), item.toJsonString());
            });
            jedisClient.hset(KEY_CONFIGURATION_CODE_MAP, hash);
        }
    }

    @Override
    public Map<String, ConfigurationModel> getProperties() {
        Map<String, ConfigurationModel> properties = new HashMap<>();
        Map<String,String> result = jedisClient.hgetAll(KEY_CONFIGURATION_CODE_MAP);
        if (MapUtils.isEmpty(result)) return properties;
        result.values().stream().forEach(value ->{
            ConfigurationModel model = JSON.parseObject(value, ConfigurationModel.class);
            properties.put(model.getCode(), model);
        });
        return properties;
    }

    @Override
    public ConfigurationModel getProperty(String code) {
        String result = jedisClient.hget(KEY_CONFIGURATION_CODE_MAP, code);
        if (StringUtils.isEmpty(result)) return null;
        return JSONObject.parseObject(result, ConfigurationModel.class);
    }

    @Override
    public Map<String, ConfigurationModel> getProperties(String... code) {
        Map<String,ConfigurationModel> properties = new HashMap<>();
        List<String> results = jedisClient.hmget(KEY_CONFIGURATION_CODE_MAP, code);
        if (CollectionUtils.isNotEmpty(results)) {
            results.stream().forEach(result -> {
                ConfigurationModel model = JSON.parseObject(result, ConfigurationModel.class);
                if (model != null && org.apache.commons.lang3.StringUtils.isNotEmpty(model.getCode())) {
                    properties.put(model.getCode(), model);
                }
            });
        }

        return properties;
    }
}

