/*
 * Decompiled with CFR 0.152.
 */
package cn.iotwasu.profile;

import cn.iotwasu.http.IotResponse;
import cn.iotwasu.hutool.core.util.StrUtil;
import cn.iotwasu.hutool.log.Log;
import cn.iotwasu.hutool.log.LogFactory;
import cn.iotwasu.profile.GrantType;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class IotProfile {
    private static final Log logger = LogFactory.get();
    public static volatile Map<String, String> systemVersionMap = new ConcurrentHashMap<String, String>();
    public static volatile boolean inited = Boolean.FALSE;
    public static String host;
    public static String clientId;
    public static String clientSecret;
    public static GrantType grantType;
    public static String username;
    public static String password;
    public static String pwdClientId;
    public static String pwdClientSecret;
    public static String CONFIG_CLIENT_USERID;
    public static boolean CONFIG_CLIENT_USERID_ENABLE;
    private static String HTTPS_PROTOCOL;
    public static String URL_SCHEME;
    private static String HTTP_PROTOCOL;
    private final String CONFIG_HTTPS = "iot.sdk.enable.https";
    private volatile Properties configuration = new Properties();

    private IotProfile() {
        this.init();
    }

    public static synchronized IotProfile getInstance() {
        return ConfigurationHolder.configuration;
    }

    public synchronized void init() {
        if (inited) {
            return;
        }
        inited = true;
        this.loadEnvConfig();
    }

    private void loadEnvConfig() {
        this.loadIccSdkProperties();
        String configClientEnable = "iot.sdk.config.client.enable";
        if (this.configuration.containsKey(configClientEnable) && "false".equalsIgnoreCase(this.configuration.getProperty(configClientEnable))) {
            CONFIG_CLIENT_USERID_ENABLE = false;
        } else {
            String configClientValue = System.getProperty(configClientEnable);
            if (StrUtil.isNotBlank((CharSequence)configClientValue)) {
                CONFIG_CLIENT_USERID_ENABLE = Boolean.parseBoolean(configClientValue);
            }
        }
        String configClientUserId = "wasu.iot.sdk.config.client.userId";
        if (this.configuration.containsKey(configClientUserId)) {
            CONFIG_CLIENT_USERID = this.configuration.getProperty(configClientUserId);
        } else {
            String configUserId = System.getProperty(configClientUserId);
            if (StrUtil.isNotBlank((CharSequence)configUserId)) {
                CONFIG_CLIENT_USERID = configUserId;
            }
        }
        String configHttps = "";
        configHttps = this.configuration.containsKey("iot.sdk.enable.https") ? this.configuration.getProperty("iot.sdk.enable.https") : System.getProperty("iot.sdk.enable.https");
        if (StrUtil.isNotBlank((CharSequence)configHttps) && "false".equalsIgnoreCase(configHttps)) {
            HTTPS_PROTOCOL = HTTP_PROTOCOL;
        }
        String sdkHost = "wasu.iot.sdk.host";
        if (StrUtil.isBlank((CharSequence)host) && this.configuration.containsKey(sdkHost)) {
            host = this.configuration.getProperty(sdkHost);
        } else if (StrUtil.isBlank((CharSequence)host)) {
            host = System.getProperty(sdkHost);
        }
        URL_SCHEME = HTTPS_PROTOCOL + host;
        String sdkClientId = "wasu.iot.sdk.clientId";
        if (StrUtil.isBlank((CharSequence)clientId) && this.configuration.containsKey(sdkClientId)) {
            clientId = this.configuration.getProperty(sdkClientId);
        } else if (StrUtil.isBlank((CharSequence)clientId)) {
            clientId = System.getProperty(sdkClientId);
        }
        String sdkClientSecret = "wasu.iot.sdk.clientSecret";
        if (StrUtil.isBlank((CharSequence)clientSecret) && this.configuration.containsKey(sdkClientSecret)) {
            clientSecret = StrUtil.trim((CharSequence)this.configuration.getProperty(sdkClientSecret));
        } else if (StrUtil.isBlank((CharSequence)clientSecret)) {
            clientSecret = System.getProperty(sdkClientSecret);
        }
        String sdkUsername = "wasu.iot.sdk.username";
        if (StrUtil.isBlank((CharSequence)username) && this.configuration.containsKey(sdkUsername)) {
            username = this.configuration.getProperty(sdkUsername);
        } else if (StrUtil.isBlank((CharSequence)username)) {
            username = System.getProperty(sdkUsername);
        }
        String sdkPassword = "wasu.iot.sdk.password";
        if (StrUtil.isBlank((CharSequence)password) && this.configuration.containsKey(sdkPassword)) {
            password = this.configuration.getProperty(sdkPassword);
        } else if (StrUtil.isBlank((CharSequence)password)) {
            password = System.getProperty(sdkPassword);
        }
        String sdkGrantType = "wasu.iot.sdk.grantType";
        if (grantType == null && this.configuration.containsKey(sdkGrantType)) {
            sdkGrantType = this.configuration.getProperty(sdkGrantType);
            grantType = GrantType.valueOf(sdkGrantType);
        } else if (grantType == null && StrUtil.isNotBlank((CharSequence)System.getProperty(sdkGrantType))) {
            sdkGrantType = System.getProperty(sdkGrantType);
            grantType = GrantType.valueOf(sdkGrantType);
        }
        if (grantType == null) {
            logger.error("IccProfile grantType can not be null , please set first", new Object[0]);
        }
        if (grantType != null && grantType.equals((Object)GrantType.password) && (StrUtil.isBlank((CharSequence)username) || StrUtil.isBlank((CharSequence)password))) {
            logger.error("GrantType type [password] ,`username` or `password` `pwdClientId` or `pwdClientSecret` can not null,please set first", new Object[0]);
        }
        if (grantType != null && grantType.equals((Object)GrantType.client_credentials) && (StrUtil.isBlank((CharSequence)clientId) || StrUtil.isBlank((CharSequence)clientSecret))) {
            logger.error("GrantType type [client_credentials] ,`clientId` or `clientSecret` can not null,please set first", new Object[0]);
        }
    }

    private void loadIccSdkProperties() {
        InputStream is = this.getClass().getResourceAsStream("/config/iotSdk.properties");
        if (is != null) {
            try {
                this.configuration.clear();
                this.configuration.load(is);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        } else {
            logger.info("can not load [classpath:resources/config/iotSdk.properties] , use DefaultClient constructor instead ", new Object[0]);
        }
    }

    static {
        CONFIG_CLIENT_USERID = "1";
        CONFIG_CLIENT_USERID_ENABLE = Boolean.TRUE;
        URL_SCHEME = HTTPS_PROTOCOL = "http://";
        HTTP_PROTOCOL = "http://";
    }

    static class SystemVersions
    extends IotResponse {
        private VersionInfoDO data;

        SystemVersions() {
        }

        public VersionInfoDO getData() {
            return this.data;
        }

        public void setData(VersionInfoDO data) {
            this.data = data;
        }

        @Override
        public String toString() {
            return "SystemVersions{data=" + this.data + '}';
        }

        public class VersionInfoDO {
            private List<VersionInfo> versionInfo;

            public List<VersionInfo> getVersionInfo() {
                return this.versionInfo;
            }

            public void setVersionInfo(List<VersionInfo> versionInfo) {
                this.versionInfo = versionInfo;
            }
        }
    }

    static class VersionInfo {
        private String systemName;
        private String version;

        VersionInfo() {
        }

        public String getSystemName() {
            return this.systemName;
        }

        public void setSystemName(String systemName) {
            this.systemName = systemName;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "VersionInfo{systemName='" + this.systemName + '\'' + ", version='" + this.version + '\'' + '}';
        }
    }

    private static class ConfigurationHolder {
        private static IotProfile configuration = new IotProfile();

        private ConfigurationHolder() {
        }
    }
}

