/*
 * Decompiled with CFR 0.152.
 */
package cn.iotwasu.model.v202203;

import cn.iotwasu.constant.OauthConstant;
import cn.iotwasu.http.AbstractIccRequest;
import cn.iotwasu.hutool.http.Method;
import cn.iotwasu.hutool.json.JSONUtil;
import cn.iotwasu.iot.exception.ClientException;
import cn.iotwasu.model.v202010.GeneralResponse;
import java.util.HashMap;
import java.util.Map;

public class CreateDeviceRequest
extends AbstractIccRequest<GeneralResponse> {
    private String deviceId;
    private String deviceName;
    private String code;
    private String deviceKey;
    private String latitude;
    private String longitude;
    private String model;
    private String detail;
    private Boolean ignoreRepeat;
    private Map<String, Object> data = new HashMap<String, Object>();

    public CreateDeviceRequest(String productKey) throws ClientException {
        super(OauthConstant.url(String.format("/api/iot/device/%s/add", productKey)), Method.POST);
        this.putBodyParameter("cmd", "dev_add");
    }

    @Override
    public Class<GeneralResponse> getResponseClass() {
        return GeneralResponse.class;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        this.putBodyParameter("deviceId", deviceId);
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.data.put("deviceName", deviceName);
        this.putBodyParameter("data", this.data);
    }

    public void setCode(String code) {
        this.code = code;
        this.data.put("code", code);
        this.putBodyParameter("data", this.data);
    }

    public void setDeviceKey(String deviceKey) {
        this.deviceKey = deviceKey;
        this.putBodyParameter("deviceKey", deviceKey);
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
        this.data.put("latitude", latitude);
        this.putBodyParameter("data", this.data);
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
        this.data.put("longitude", longitude);
        this.putBodyParameter("data", this.data);
    }

    public void addData(String key, Object value) {
        this.data.put(key, value);
        this.putBodyParameter("data", this.data);
    }

    public void setModel(String model) {
        this.model = model;
        this.data.put("model", model);
        this.putBodyParameter("data", this.data);
    }

    public void setDetail(String detail) {
        this.detail = detail;
        this.putBodyParameter("detail", detail);
    }

    public void setIgnoreRepeat(Boolean ignoreRepeat) {
        this.ignoreRepeat = ignoreRepeat;
        this.putBodyParameter("ignoreRepeat", ignoreRepeat);
    }

    public Boolean getIgnoreRepeat() {
        return this.ignoreRepeat;
    }

    public String getModel() {
        return this.model;
    }

    public String getCode() {
        return this.code;
    }

    public String getDeviceKey() {
        return this.deviceKey;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public String getDetail() {
        return this.detail;
    }

    public String toString() {
        return JSONUtil.toJsonStr((Object)this.bodyParameters);
    }
}

