/*
 * Decompiled with CFR 0.152.
 */
package cn.iotwasu.http;

import cn.iotwasu.http.DefaultClient;
import cn.iotwasu.http.IClient;
import cn.iotwasu.http.IotClient;
import cn.iotwasu.hutool.core.util.StrUtil;
import cn.iotwasu.hutool.http.Method;
import cn.iotwasu.hutool.json.JSONUtil;
import cn.iotwasu.hutool.log.Log;
import cn.iotwasu.hutool.log.LogFactory;
import cn.iotwasu.iot.exception.ClientException;
import cn.iotwasu.iot.util.CollectionUtil;
import cn.iotwasu.model.v202010.GeneralRequest;
import cn.iotwasu.model.v202010.GeneralResponse;
import cn.iotwasu.model.v202203.CreateDeviceRequest;
import cn.iotwasu.model.v202203.UpdateDeviceRequest;
import java.util.HashMap;
import java.util.Map;

public class IotClientImpl
implements IotClient {
    private static final Log logger = LogFactory.get();
    private IClient iClient = new DefaultClient();

    @Override
    public String register(CreateDeviceRequest createDeviceRequest) {
        String re = null;
        try {
            if (StrUtil.isBlank((CharSequence)createDeviceRequest.getDeviceId())) {
                throw new RuntimeException("deviceId \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)createDeviceRequest.getDeviceName())) {
                throw new RuntimeException("deviceName \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)createDeviceRequest.getLatitude())) {
                throw new RuntimeException("latitude \u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)createDeviceRequest.getLongitude())) {
                throw new RuntimeException("longitude \u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            re = this.iClient.doAction(createDeviceRequest);
            logger.info("\u6dfb\u52a0\u8bbe\u5907={} \u8fd4\u56de={}", new Object[]{JSONUtil.toJsonStr((Object)createDeviceRequest), re});
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return re;
    }

    @Override
    public GeneralResponse delete(String productKey, String deviceId) {
        GeneralResponse re = null;
        if (StrUtil.isBlank((CharSequence)productKey) || StrUtil.isBlank((CharSequence)deviceId)) {
            throw new RuntimeException("productKey\u6216deviceId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            GeneralRequest request = new GeneralRequest(String.format("/api/iot/v2/device/del/%s/%s", productKey, deviceId), Method.DELETE);
            re = this.iClient.doAction(request, GeneralResponse.class);
            logger.info("\u8bbe\u5907\u5220\u9664={} \u8fd4\u56de={}", new Object[]{deviceId, re});
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return re;
    }

    @Override
    public GeneralResponse update(UpdateDeviceRequest updateDeviceRequest) {
        GeneralResponse re = null;
        try {
            if (StrUtil.isBlank((CharSequence)updateDeviceRequest.getDeviceName())) {
                throw new RuntimeException("deviceName \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)updateDeviceRequest.getLatitude())) {
                throw new RuntimeException("latitude \u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)updateDeviceRequest.getLongitude())) {
                throw new RuntimeException("longitude \u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            re = this.iClient.doAction(updateDeviceRequest, GeneralResponse.class);
            logger.info("\u6dfb\u52a0\u66f4\u65b0={} \u8fd4\u56de={}", new Object[]{JSONUtil.toJsonStr((Object)updateDeviceRequest), re});
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return re;
    }

    @Override
    public GeneralResponse query(String productKey, String deviceId) {
        GeneralResponse re = null;
        if (StrUtil.isBlank((CharSequence)productKey) || StrUtil.isBlank((CharSequence)deviceId)) {
            throw new RuntimeException("productKey\u6216deviceId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            GeneralRequest request = new GeneralRequest(String.format("/api/iot/v2/device/info/%s/%s", productKey, deviceId), Method.GET);
            re = this.iClient.doAction(request, GeneralResponse.class);
            logger.info("\u8bbe\u5907\u67e5\u8be2={} \u8fd4\u56de={}", new Object[]{deviceId, re});
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return re;
    }

    @Override
    public GeneralResponse online(String productKey, String deviceId) {
        GeneralResponse re = null;
        if (StrUtil.isBlank((CharSequence)productKey) || StrUtil.isBlank((CharSequence)deviceId)) {
            throw new RuntimeException("productKey\u6216deviceId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            GeneralRequest request = new GeneralRequest(String.format("/api/iot/v2/online/%s/%s", productKey, deviceId), Method.PUT);
            re = this.iClient.doAction(request, GeneralResponse.class);
            logger.info("\u8bbe\u5907\u4e0a\u7ebf={} \u8fd4\u56de={}", new Object[]{deviceId, re});
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return re;
    }

    @Override
    public GeneralResponse reportProperties(String productKey, String deviceId, Map<String, Object> properties) {
        GeneralResponse re = null;
        if (StrUtil.isBlank((CharSequence)productKey) || StrUtil.isBlank((CharSequence)deviceId)) {
            throw new RuntimeException("productKey\u6216deviceId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            GeneralRequest request = new GeneralRequest(String.format("/api/iot/v2/device/report/properties/%s/%s", productKey, deviceId), Method.POST);
            HashMap<String, Map<String, Object>> msg = new HashMap<String, Map<String, Object>>();
            msg.put("properties", properties);
            String body = JSONUtil.toJsonStr(msg);
            request.body(body);
            re = this.iClient.doAction(request, GeneralResponse.class);
            logger.info("\u8bbe\u5907\u7f16\u53f7={} \u4e0a\u62a5\u5c5e\u6027={} \u8fd4\u56de={}", new Object[]{deviceId, body, re});
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return re;
    }

    @Override
    public GeneralResponse reportEvent(String productKey, String deviceId, String event, Map<String, Object> data) {
        GeneralResponse re = null;
        if (StrUtil.isBlank((CharSequence)productKey) || StrUtil.isBlank((CharSequence)deviceId)) {
            throw new RuntimeException("productKey\u6216deviceId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            GeneralRequest request = new GeneralRequest(String.format("/api/iot/v2/device/report/event/%s/%s", productKey, deviceId), Method.POST);
            HashMap<String, Object> msg = new HashMap<String, Object>();
            msg.put("event", event);
            msg.put("messageType", "EVENT");
            if (!CollectionUtil.isEmpty(data)) {
                msg.put("data", data);
            }
            String body = JSONUtil.toJsonStr(msg);
            request.body(body);
            re = this.iClient.doAction(request, GeneralResponse.class);
            logger.info("\u8bbe\u5907\u7f16\u53f7={} \u4e0a\u62a5\u4e8b\u4ef6={} \u8fd4\u56de={}", new Object[]{deviceId, body, re});
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return re;
    }

    @Override
    public GeneralResponse offline(String productKey, String deviceId) {
        return null;
    }
}

