/*
 * Decompiled with CFR 0.152.
 */
package cn.iotwasu.http;

import cn.iotwasu.handle.TokenHandleSingle;
import cn.iotwasu.http.AbstractIClient;
import cn.iotwasu.http.IotHttpRequest;
import cn.iotwasu.http.IotResponse;
import cn.iotwasu.http.IotTokenResponse;
import cn.iotwasu.hutool.core.util.StrUtil;
import cn.iotwasu.hutool.http.HttpResponse;
import cn.iotwasu.hutool.json.JSONUtil;
import cn.iotwasu.hutool.log.Log;
import cn.iotwasu.hutool.log.LogFactory;
import cn.iotwasu.iot.exception.ClientException;
import cn.iotwasu.iot.exception.ServerException;
import cn.iotwasu.profile.GrantType;
import cn.iotwasu.profile.IotProfile;
import cn.iotwasu.unmarshaller.JsonUnmashaller;
import cn.iotwasu.unmarshaller.Unmarshaller;

public class DefaultClient
extends AbstractIClient {
    private static final Log logger = LogFactory.get();
    private TokenHandleSingle tokenHandleSingle;
    private Unmarshaller unmarshaller;

    public DefaultClient() throws ClientException {
        IotProfile.getInstance().init();
        this.tokenHandleSingle = TokenHandleSingle.getInstance();
        this.unmarshaller = new JsonUnmashaller();
    }

    public DefaultClient(String host, String clientId, String clientSecret) throws ClientException {
        this.init(host, clientId, clientSecret);
    }

    public DefaultClient(String host, String username, String password, String pwdClientId, String pwdClientSecret) throws ClientException {
        this.init(host, username, password, "web", "web");
    }

    private void init(String host, String clientId, String clientSecret) {
        this.init(host, null, null, clientId, clientSecret, GrantType.client_credentials);
    }

    private void init(String host, String username, String password, String pwdClientId, String pwdClientSecret) {
        this.init(host, username, password, "web", "web", GrantType.password);
    }

    private void init(String host, String username, String password, String pwdClientId, String pwdClientSecret, GrantType grantType) {
        if (IotProfile.inited && !IotProfile.host.equals(host)) {
            TokenHandleSingle.getInstance().getTokenMap().clear();
        }
        IotProfile.host = host;
        IotProfile.grantType = grantType;
        switch (grantType) {
            case password: {
                IotProfile.pwdClientSecret = pwdClientSecret;
                IotProfile.pwdClientId = pwdClientId;
                break;
            }
            case client_credentials: {
                IotProfile.clientId = pwdClientId;
                IotProfile.clientSecret = pwdClientSecret;
                break;
            }
        }
        IotProfile.password = password;
        IotProfile.username = username;
        IotProfile.inited = Boolean.FALSE;
        IotProfile.getInstance().init();
        this.tokenHandleSingle = TokenHandleSingle.getInstance();
        this.unmarshaller = new JsonUnmashaller();
    }

    @Override
    public String doAction(IotHttpRequest request) throws ClientException, ServerException {
        IotHttpRequest iotHttpRequest = this.signRequest(request);
        String httpResult = iotHttpRequest.execute();
        logger.debug("response httpResult =[{}]", new Object[]{httpResult});
        return httpResult;
    }

    @Override
    public <T extends IotResponse> T doAction(IotHttpRequest request, Class<T> tClass) throws ClientException, ServerException {
        IotHttpRequest iotHttpRequest = this.signRequest(request);
        HttpResponse httpResult = iotHttpRequest.executeResponse();
        String result = httpResult.body();
        logger.debug("response httpResult =[{}]", new Object[]{result});
        T t = this.unmarshal(tClass, result);
        ((IotResponse)t).setResult(result);
        return t;
    }

    @Override
    public synchronized IotTokenResponse getAccessToken(GrantType grantType) {
        IotTokenResponse token = this.tokenHandleSingle.getTokenCache(grantType.name());
        if (token != null) {
            return token;
        }
        token = this.tokenHandleSingle.refreshToken(grantType);
        return token;
    }

    @Override
    public IotTokenResponse getAccessToken() {
        return this.getAccessToken(IotProfile.grantType);
    }

    @Override
    IotHttpRequest signRequest(IotHttpRequest request) {
        if (request.isNeedAuth()) {
            IotTokenResponse token = this.getAccessToken(IotProfile.grantType);
            request.header("Authorization", "bearer " + (token != null ? token.getAccess_token() : ""));
            if (IotProfile.grantType.equals((Object)GrantType.client_credentials) && IotProfile.CONFIG_CLIENT_USERID_ENABLE) {
                request.header("User-Id", IotProfile.CONFIG_CLIENT_USERID);
            }
        }
        if (request.getBodyParameters().size() > 0 && StrUtil.isBlank((CharSequence)request.getBody())) {
            request.body(JSONUtil.toJsonStr(request.getBodyParameters()));
        }
        return request;
    }

    @Override
    public <T extends IotResponse> T unmarshal(Class<T> clasz, String content) throws ClientException {
        return this.unmarshaller.unmarshal(clasz, content);
    }
}

