/*
 * Decompiled with CFR 0.152.
 */
package cn.iotwasu.handle;

import cn.iotwasu.constant.OauthConstant;
import cn.iotwasu.http.DefaultClient;
import cn.iotwasu.http.IotHttpRequest;
import cn.iotwasu.http.IotTokenResponse;
import cn.iotwasu.hutool.core.thread.NamedThreadFactory;
import cn.iotwasu.hutool.core.util.ObjectUtil;
import cn.iotwasu.hutool.core.util.StrUtil;
import cn.iotwasu.hutool.http.Method;
import cn.iotwasu.hutool.log.Log;
import cn.iotwasu.hutool.log.LogFactory;
import cn.iotwasu.iot.exception.ClientException;
import cn.iotwasu.iot.exception.ServerException;
import cn.iotwasu.iot.util.BeanUtil;
import cn.iotwasu.model.v202010.OauthRefreshTokenRequest;
import cn.iotwasu.model.v202010.OauthRefreshTokenResponse;
import cn.iotwasu.profile.GrantType;
import cn.iotwasu.profile.IotProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TokenHandleSingle {
    private static final Log logger = LogFactory.get();
    private static final AtomicBoolean TOKEN_INITED = new AtomicBoolean(Boolean.FALSE);
    private static final long FRESH_TOKEN_INTERVAL = 15000L;
    private final ScheduledExecutorService REFRESH_TOKEN_SCHEDULED = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("Iot-Refresh-Token", true));
    private final Map<String, IotTokenResponse> tokenMap = new ConcurrentHashMap<String, IotTokenResponse>();

    public Map<String, IotTokenResponse> getTokenMap() {
        return this.tokenMap;
    }

    private TokenHandleSingle() {
        this.REFRESH_TOKEN_SCHEDULED.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    TokenHandleSingle.this.refreshTokenAndKeepAlive();
                }
                catch (Throwable t) {
                    logger.error("Unexpected error occur at token refresh, cause: " + t.getMessage(), new Object[]{t});
                }
            }
        }, 15000L, 15000L, TimeUnit.MILLISECONDS);
    }

    public static synchronized TokenHandleSingle getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public synchronized IotTokenResponse refreshToken(GrantType grantType) {
        IotTokenResponse token = null;
        try {
            switch (grantType) {
                case password: {
                    token = this.password();
                    break;
                }
                case client_credentials: {
                    token = this.clientCredentials();
                    break;
                }
            }
        }
        catch (ClientException e) {
            logger.error("get token failure", new Object[0]);
        }
        if (!TOKEN_INITED.get() && token != null) {
            TOKEN_INITED.set(Boolean.TRUE);
        }
        return token;
    }

    private IotTokenResponse password() throws ClientException, ServerException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("grant_type", "password");
        map.put("username", IotProfile.username);
        map.put("password", IotProfile.password);
        map.put("client_id", "web");
        map.put("client_secret", "web");
        map.put("scope", "all");
        IotHttpRequest pr = new IotHttpRequest(OauthConstant.url("/oauth/token"), Method.POST);
        pr.form(map);
        String prBody = pr.execute();
        IotTokenResponse token = (IotTokenResponse)BeanUtil.toBean((String)prBody, IotTokenResponse.class);
        if (token == null || StrUtil.isBlank((CharSequence)token.getAccess_token())) {
            logger.error(" auth failure [{}] reason [{}]", new Object[]{OauthConstant.url("/oauth/token"), token == null ? "" : ""});
            throw new ClientException("GrantType [password] username=[" + IotProfile.username + "],password=[" + IotProfile.password + "] get access_token failure");
        }
        IotTokenResponse iotToken = token;
        iotToken.setTtl(System.currentTimeMillis() + iotToken.getExpires_in() * 1000L);
        this.tokenMap.put(this.enGrantKeyName(GrantType.password.name()), iotToken);
        return iotToken;
    }

    private IotTokenResponse clientCredentials() throws ClientException, ServerException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("grant_type", "client_credentials");
        map.put("client_id", IotProfile.clientId);
        map.put("client_secret", IotProfile.clientSecret);
        IotHttpRequest cr = new IotHttpRequest(OauthConstant.url("/oauth/token"), Method.POST);
        cr.form(map);
        String crBody = cr.execute();
        IotTokenResponse token = (IotTokenResponse)BeanUtil.toBean((String)crBody, IotTokenResponse.class);
        if (token == null) {
            logger.error("client auth failure [{}] reason [{}]", new Object[]{OauthConstant.url("/oauth/token"), token == null ? "" : ""});
            throw new ClientException("client auth failure" + (token == null ? "" : ""));
        }
        IotTokenResponse iotToken = new IotTokenResponse();
        iotToken.setAccess_token(token.getAccess_token());
        iotToken.setExpires_in(token.getExpires_in());
        iotToken.setScope(token.getScope());
        iotToken.setToken_type(token.getToken_type());
        iotToken.setTtl(System.currentTimeMillis() + iotToken.getExpires_in() * 1000L);
        this.tokenMap.put(this.enGrantKeyName(GrantType.client_credentials.name()), iotToken);
        return iotToken;
    }

    public IotTokenResponse getTokenCache(String grantType) {
        return this.tokenMap.get(this.enGrantKeyName(grantType));
    }

    public IotTokenResponse refreshToken(GrantType grantType, String accessToken, String refreshToken) {
        try {
            logger.info("do refreshToken,accessToken={} ,refreshToken={}", new Object[]{accessToken, refreshToken});
            DefaultClient iClient = new DefaultClient();
            OauthRefreshTokenRequest refreshTokenRequest = new OauthRefreshTokenRequest();
            if (grantType.equals((Object)GrantType.password)) {
                refreshTokenRequest.setClient_id("web");
                refreshTokenRequest.setClient_secret("web");
                refreshTokenRequest.setGrant_type(GrantType.refresh_token.name());
                refreshTokenRequest.setRefresh_token(refreshToken);
                refreshTokenRequest.setAccess_token(accessToken);
                OauthRefreshTokenResponse refreshTokenResponse = iClient.doAction(refreshTokenRequest, refreshTokenRequest.getResponseClass());
                if (ObjectUtil.isNull((Object)refreshTokenResponse) || ObjectUtil.isEmpty((Object)refreshTokenResponse.getExpires_in())) {
                    return this.password();
                }
                IotTokenResponse iotToken = new IotTokenResponse();
                iotToken.setTtl(System.currentTimeMillis() + refreshTokenResponse.getExpires_in() * 1000L);
                iotToken.setAccess_token(refreshTokenResponse.getAccess_token());
                iotToken.setExpires_in(refreshTokenResponse.getExpires_in());
                iotToken.setToken_type(refreshTokenResponse.getToken_type());
                iotToken.setRefresh_token(refreshTokenResponse.getRefresh_token());
                iotToken.setScope(refreshTokenResponse.getScope());
                return iotToken;
            }
            if (grantType.equals((Object)GrantType.client_credentials)) {
                return this.clientCredentials();
            }
        }
        catch (ClientException e) {
            logger.error("fresh token error , grantType=[{}],freshToken=[{}]", new Object[]{grantType.name(), refreshToken});
            this.tokenMap.clear();
        }
        return null;
    }

    private void refreshTokenAndKeepAlive() {
        if (TOKEN_INITED.get() && this.tokenMap.size() > 0) {
            for (Map.Entry<String, IotTokenResponse> entry : this.tokenMap.entrySet()) {
                GrantType grantType;
                IotTokenResponse token = entry.getValue();
                Long currentTime = System.currentTimeMillis();
                if (token.getTtl() - currentTime > 1200000L || (token = this.refreshToken(grantType = this.deGrantType(entry.getKey()), token.getAccess_token(), token.getRefresh_token())) == null) continue;
                this.tokenMap.remove(entry.getKey());
                this.tokenMap.put(entry.getKey(), token);
                logger.info("refresh token success, [{}],token=[{}]", new Object[]{entry.getKey(), token});
            }
        }
    }

    private String enGrantKeyName(String grantType) {
        return grantType + ":" + IotProfile.host;
    }

    private GrantType deGrantType(String grantKeyName) {
        return GrantType.valueOf(grantKeyName.substring(0, grantKeyName.indexOf(":")));
    }

    private static class SingletonHolder {
        private static final TokenHandleSingle INSTANCE = new TokenHandleSingle();

        private SingletonHolder() {
        }
    }
}

