/*
 * Copyright 2017 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package cn.iotwasu.iot.exception;

/**
 * @author liulihai
 * @since 2020-10-24 20:59:11
 */
public class IccException extends Exception {

  private String errorMsg;
  private int errorCode;

  public IccException(int code, String msg) {
    errorCode = code;
    errorMsg = msg;
  }

  public IccException(int code, Throwable e) {
    errorCode = code;
    errorMsg = e.getMessage();
  }

  public String getErrorMsg() {
    return errorMsg;
  }

  public void setErrorMsg(String errorMsg) {
    this.errorMsg = errorMsg;
  }

  public int getErrorCode() {
    return errorCode;
  }

  public void setErrorCode(int errorCode) {
    this.errorCode = errorCode;
  }
}
