/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.utils.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;

public class JsonMapper {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true).configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).registerModule((Module)new SimpleModule());

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static <T> T convertObject(Object obj, Class<T> clazz) {
        return (T)OBJECT_MAPPER.convertValue(obj, clazz);
    }

    public static <T> T convertObject(Object obj, TypeReference<T> valueTypeRef) {
        return (T)OBJECT_MAPPER.convertValue(obj, valueTypeRef);
    }

    public static <T> T readValue(String obj, Class<T> clazz) throws JsonProcessingException {
        return (T)OBJECT_MAPPER.readValue(obj, clazz);
    }

    public static <T> T readValue(String obj, TypeReference<T> valueTypeRef) throws JsonProcessingException {
        return (T)OBJECT_MAPPER.readValue(obj, valueTypeRef);
    }
}

