/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.web.conf;

import cn.iosd.starter.web.properties.OpenApiProperties;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import jakarta.annotation.Resource;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenApiAutoConfiguration {
    @Resource
    private OpenApiProperties openApiProperties;
    @Value(value="${spring.application.name}")
    private String applicationName;
    private static final String BASE_PATH = "/**";
    private static final String COMPONENT_SECURITY_SCHEME_KEY = "AccessToken";

    @Bean
    public GroupedOpenApi userApi() {
        return GroupedOpenApi.builder().group(this.titleName()).pathsToMatch(new String[]{BASE_PATH}).build();
    }

    @Bean
    public OpenAPI openApi() {
        Info info = new Info().title(this.titleName()).description(this.openApiProperties.getDescription()).version(this.openApiProperties.getVersion());
        Contact contact = new Contact();
        contact.setName(this.openApiProperties.getContact().getName());
        contact.setEmail(this.openApiProperties.getContact().getEmail());
        contact.setUrl(this.openApiProperties.getContact().getUrl());
        info.contact(contact);
        OpenAPI openApi = new OpenAPI();
        openApi.info(new Info().title(this.openApiProperties.getTitle()).description(this.openApiProperties.getDescription()).contact(contact).version(this.openApiProperties.getVersion()));
        openApi.components(this.components()).addSecurityItem(new SecurityRequirement().addList(COMPONENT_SECURITY_SCHEME_KEY));
        return openApi;
    }

    private Components components() {
        HashMap<String, SecurityScheme> securitySchemeMap = new HashMap<String, SecurityScheme>(16);
        SecurityScheme securityScheme = new SecurityScheme();
        securityScheme.setType(SecurityScheme.Type.APIKEY);
        securityScheme.setName("Authorization");
        securityScheme.in(SecurityScheme.In.HEADER);
        securitySchemeMap.put(COMPONENT_SECURITY_SCHEME_KEY, securityScheme);
        return new Components().securitySchemes(securitySchemeMap);
    }

    private String titleName() {
        if (StringUtils.isBlank((CharSequence)this.openApiProperties.getTitle())) {
            return this.applicationName;
        }
        return this.openApiProperties.getTitle();
    }
}

