/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.web.domain;

import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="\u54cd\u5e94\u4fe1\u606f\u4e3b\u4f53")
public class Response<T> {
    public static final int SUCCESS = 200;
    public static final int FAIL = 500;
    @Schema(description="\u72b6\u6001\u7801")
    private int code;
    @Schema(description="\u54cd\u5e94\u4fe1\u606f")
    private String msg;
    @Schema(description="\u54cd\u5e94\u6570\u636e")
    private T data;

    public static <T> Response<T> ok() {
        return Response.restResult(null, 200, "\u64cd\u4f5c\u6210\u529f");
    }

    public static <T> Response<T> ok(T data) {
        return Response.restResult(data, 200, "\u64cd\u4f5c\u6210\u529f");
    }

    public static <T> Response<T> ok(T data, String msg) {
        return Response.restResult(data, 200, msg);
    }

    public static <T> Response<T> fail() {
        return Response.restResult(null, 500, null);
    }

    public static <T> Response<T> fail(String msg) {
        return Response.restResult(null, 500, msg);
    }

    public static <T> Response<T> fail(T data) {
        return Response.restResult(data, 500, null);
    }

    public static <T> Response<T> fail(T data, String msg) {
        return Response.restResult(data, 500, msg);
    }

    public static <T> Response<T> fail(int code, String msg) {
        return Response.restResult(null, code, msg);
    }

    private static <T> Response<T> restResult(T data, int code, String msg) {
        Response<T> apiResult = new Response<T>();
        apiResult.setCode(code);
        apiResult.setData(data);
        apiResult.setMsg(msg);
        return apiResult;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static <T> Boolean isError(Response<T> ret) {
        return Response.isSuccess(ret) == false;
    }

    public static <T> Boolean isSuccess(Response<T> ret) {
        return 200 == ret.getCode();
    }
}

