/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.web.conf;

import cn.iosd.starter.web.properties.OpenApiProperties;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenApiAutoConfiguration {
    @Autowired
    private OpenApiProperties openApiProperties;
    @Value(value="${spring.application.name}")
    private String applicationName;
    private static final String BASE_PATH = "/**";
    private static final String COMPONENT_SECURITY_SCHEME_KEY = "AccessToken";

    @Bean
    public GroupedOpenApi userApi() {
        return GroupedOpenApi.builder().group(this.titleName()).pathsToMatch(new String[]{BASE_PATH}).build();
    }

    @Bean
    public OpenAPI openApi() {
        Contact contact = new Contact();
        contact.setName(this.openApiProperties.getContact().getName());
        contact.setUrl(this.openApiProperties.getContact().getUrl());
        contact.setEmail(this.openApiProperties.getContact().getEmail());
        OpenAPI openApi = new OpenAPI().info(new Info().title(this.titleName()).description(this.openApiProperties.getDescription()).contact(contact).version(this.openApiProperties.getVersion()));
        openApi.addSecurityItem(new SecurityRequirement().addList(COMPONENT_SECURITY_SCHEME_KEY));
        openApi.components(new Components().securitySchemes(Collections.singletonMap(COMPONENT_SECURITY_SCHEME_KEY, new SecurityScheme().type(SecurityScheme.Type.APIKEY).name("Authorization").in(SecurityScheme.In.HEADER))));
        return openApi;
    }

    private String titleName() {
        return StringUtils.isNotBlank((CharSequence)this.openApiProperties.getTitle()) ? this.openApiProperties.getTitle() : this.applicationName;
    }
}

