/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.web.domain;

import java.io.Serializable;

public class Response<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SUCCESS = 200;
    public static final int FAIL = 500;
    private int code;
    private String msg;
    private T data;

    public static <T> Response<T> ok() {
        return Response.restResult(null, 200, "\u64cd\u4f5c\u6210\u529f");
    }

    public static <T> Response<T> ok(T data) {
        return Response.restResult(data, 200, "\u64cd\u4f5c\u6210\u529f");
    }

    public static <T> Response<T> ok(T data, String msg) {
        return Response.restResult(data, 200, msg);
    }

    public static <T> Response<T> fail() {
        return Response.restResult(null, 500, null);
    }

    public static <T> Response<T> fail(String msg) {
        return Response.restResult(null, 500, msg);
    }

    public static <T> Response<T> fail(T data) {
        return Response.restResult(data, 500, null);
    }

    public static <T> Response<T> fail(T data, String msg) {
        return Response.restResult(data, 500, msg);
    }

    public static <T> Response<T> fail(int code, String msg) {
        return Response.restResult(null, code, msg);
    }

    private static <T> Response<T> restResult(T data, int code, String msg) {
        Response<T> apiResult = new Response<T>();
        apiResult.setCode(code);
        apiResult.setData(data);
        apiResult.setMsg(msg);
        return apiResult;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static <T> Boolean isError(Response<T> ret) {
        return Response.isSuccess(ret) == false;
    }

    public static <T> Boolean isSuccess(Response<T> ret) {
        return 200 == ret.getCode();
    }
}

