/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.s3.service;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class AmazonS3Service {
    @Autowired
    @Qualifier(value="amazonS3Simple")
    private AmazonS3 client;

    public void putObject(ObjectMetadata metadata, InputStream input, String bucket, String key) {
        this.client.putObject(new PutObjectRequest(bucket, key, input, metadata));
    }

    public void putObjectPublicRead(ObjectMetadata metadata, InputStream input, String bucket, String key) {
        this.client.putObject(new PutObjectRequest(bucket, key, input, metadata).withCannedAcl(CannedAccessControlList.PublicRead));
    }

    public URL generatePresignedUrl(String bucket, String key, Long expirationMinutes) {
        return this.client.generatePresignedUrl(bucket, key, AmazonS3Service.addMinutesToCurrentTime(expirationMinutes));
    }

    public List<Bucket> getListBuckets(String bucketNameFilter) {
        List buckets = this.client.listBuckets();
        if (StringUtils.isBlank((CharSequence)bucketNameFilter)) {
            return buckets;
        }
        return buckets.stream().filter(bucket -> bucket.getName().contains(bucketNameFilter)).collect(Collectors.toList());
    }

    public Bucket createBucket(String bucketName) {
        return this.client.createBucket(bucketName);
    }

    public void deleteBucket(String bucketName) {
        this.client.deleteBucket(bucketName);
    }

    public ObjectListing listObjects(String bucketName, String prefixFileName, Integer pageSize) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName).withPrefix(prefixFileName).withMaxKeys(pageSize);
        return this.client.listObjects(listObjectsRequest);
    }

    public ObjectListing listNextBatchOfObjects(ObjectListing objectListing) {
        return this.client.listNextBatchOfObjects(objectListing);
    }

    public void deleteObject(String bucketName, String key) {
        DeleteObjectRequest dor = new DeleteObjectRequest(bucketName, key);
        this.client.deleteObject(dor);
    }

    private static Date addMinutesToCurrentTime(Long minutes) {
        LocalDateTime resultTime = LocalDateTime.now().plusMinutes(minutes);
        return Date.from(resultTime.atZone(ZoneId.systemDefault()).toInstant());
    }
}

