/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.s3.service;

import cn.iosd.starter.s3.properties.S3Properties;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AmazonS3Service
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AmazonS3Service.class);
    @Autowired
    private S3Properties s3Properties;
    private AmazonS3 client;

    public void afterPropertiesSet() {
        ClientConfiguration config = new ClientConfiguration();
        config.setProtocol(Protocol.HTTP);
        config.disableSocketProxy();
        this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(config)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.s3Properties.getAccessKey(), this.s3Properties.getSecretKey())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.s3Properties.getEndpoint(), Regions.CN_NORTH_1.getName()))).enablePathStyleAccess()).build();
        log.info("AmazonS3\u5b8c\u6210\u914d\u7f6e");
    }

    public AmazonS3 getClient() {
        return this.client;
    }

    public void putObject(ObjectMetadata metadata, InputStream input, String bucket, String key) {
        this.client.putObject(new PutObjectRequest(bucket, key, input, metadata));
    }

    public void putObjectPublicRead(ObjectMetadata metadata, InputStream input, String bucket, String key) {
        this.client.putObject(new PutObjectRequest(bucket, key, input, metadata).withCannedAcl(CannedAccessControlList.PublicRead));
    }

    public URL generatePresignedUrl(String bucket, String key) {
        GeneratePresignedUrlRequest urlRequest = new GeneratePresignedUrlRequest(bucket, key);
        return this.client.generatePresignedUrl(urlRequest);
    }

    public List<Bucket> getListBuckets(String bucketNameFilter) {
        List buckets = this.client.listBuckets();
        if (StringUtils.isBlank((CharSequence)bucketNameFilter)) {
            return buckets;
        }
        return buckets.stream().filter(bucket -> bucket.getName().contains(bucketNameFilter)).collect(Collectors.toList());
    }

    public Bucket createBucket(String bucketName) {
        return this.client.createBucket(bucketName);
    }

    public void deleteBucket(String bucketName) {
        this.client.deleteBucket(bucketName);
    }

    public ObjectListing listObjects(String bucketName, String prefixFileName, Integer pageSize) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName).withPrefix(prefixFileName).withMaxKeys(pageSize);
        return this.client.listObjects(listObjectsRequest);
    }

    public ObjectListing listNextBatchOfObjects(ObjectListing objectListing) {
        return this.client.listNextBatchOfObjects(objectListing);
    }

    public void deleteObject(String bucketName, String key) {
        DeleteObjectRequest dor = new DeleteObjectRequest(bucketName, key);
        this.client.deleteObject(dor);
    }
}

