/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.s3.service.impl;

import cn.iosd.starter.s3.domain.StorageObjectRequest;
import cn.iosd.starter.s3.domain.StorageObjectResponse;
import cn.iosd.starter.s3.properties.S3Properties;
import cn.iosd.starter.s3.service.SimpleStorageService;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SimpleStorageServiceImpl
implements SimpleStorageService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SimpleStorageServiceImpl.class);
    @Autowired
    private S3Properties s3Properties;
    private AmazonS3 client;

    public void afterPropertiesSet() {
        ClientConfiguration config = new ClientConfiguration();
        config.setProtocol(Protocol.HTTP);
        config.disableSocketProxy();
        this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(config)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.s3Properties.getAccessKey(), this.s3Properties.getSecretKey())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.s3Properties.getEndpoint(), Regions.CN_NORTH_1.getName()))).enablePathStyleAccess()).build();
        log.info("AmazonS3\u5b8c\u6210\u914d\u7f6e");
    }

    @Override
    public String upload(String contentType, Long size, InputStream input, String bucket, String key) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType(contentType);
        metadata.setContentLength(size.longValue());
        this.client.putObject(new PutObjectRequest(bucket, key, input, metadata).withCannedAcl(CannedAccessControlList.PublicRead));
        GeneratePresignedUrlRequest urlRequest = new GeneratePresignedUrlRequest(bucket, key);
        URL url = this.client.generatePresignedUrl(urlRequest);
        return this.s3Properties.getEndpoint() + url.getPath();
    }

    @Override
    public List<Bucket> getListBuckets(String bucketName) {
        List buckets = this.client.listBuckets();
        if (StringUtils.isNotBlank((CharSequence)bucketName)) {
            buckets = buckets.stream().filter(s -> s.getName().contains(bucketName)).collect(Collectors.toList());
        }
        return buckets;
    }

    @Override
    public Bucket creatBucket(String bucketName) {
        return this.client.createBucket(bucketName);
    }

    @Override
    public void deleteBucket(String bucketName) {
        this.client.deleteBucket(bucketName);
    }

    @Override
    public StorageObjectResponse getStorageObject(StorageObjectRequest storageObjectRequest) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(storageObjectRequest.getBucketName()).withPrefix(storageObjectRequest.getPrefixFileName()).withMaxKeys(storageObjectRequest.getPageSize());
        ObjectListing objectListing = this.client.listObjects(listObjectsRequest);
        List summaries = objectListing.getObjectSummaries();
        StorageObjectResponse response = new StorageObjectResponse();
        response.setSummaries(summaries);
        response.setObjectListing(objectListing);
        return response;
    }

    @Override
    public StorageObjectResponse getStorageObjectNext(ObjectListing objectListing) {
        ObjectListing objectListingNext = this.client.listNextBatchOfObjects(objectListing);
        List summaries = objectListing.getObjectSummaries();
        StorageObjectResponse response = new StorageObjectResponse();
        response.setSummaries(summaries);
        response.setObjectListing(objectListingNext);
        return response;
    }

    @Override
    public Boolean deleteStorageObject(String bucketName, String objectName) {
        DeleteObjectsRequest dor = new DeleteObjectsRequest(bucketName).withKeys(new String[]{objectName});
        DeleteObjectsResult deleteObjectsResult = this.client.deleteObjects(dor);
        try {
            return !((DeleteObjectsResult.DeletedObject)deleteObjectsResult.getDeletedObjects().get(0)).isDeleteMarker();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

