/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.utils;

import cn.iosd.starter.redisson.domain.MethodContext;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpElUtil {
    private static final ExpressionParser PARSER = new SpelExpressionParser();

    public static String analytical(String spEl, Map<String, Object> argMap, String defaultValue) {
        if (spEl == null || !spEl.contains("#")) {
            return defaultValue;
        }
        Expression expression = PARSER.parseExpression(spEl);
        StandardEvaluationContext context = new StandardEvaluationContext();
        argMap.forEach((arg_0, arg_1) -> ((StandardEvaluationContext)context).setVariable(arg_0, arg_1));
        return Optional.ofNullable((String)expression.getValue((EvaluationContext)context, String.class)).filter(StringUtils::isNotEmpty).orElse(defaultValue);
    }

    public static MethodContext getArgMap(ProceedingJoinPoint point) {
        Object[] args = point.getArgs();
        Method method = ((MethodSignature)point.getSignature()).getMethod();
        String[] params = new StandardReflectionParameterNameDiscoverer().getParameterNames(method);
        if (params == null) {
            throw new IllegalArgumentException("\u65b9\u6cd5\u53c2\u6570\u65e0\u6cd5\u83b7\u53d6");
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        IntStream.range(0, args.length).forEach(i -> map.put(params[i], args[i]));
        return new MethodContext(map, method.toGenericString());
    }
}

