/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.service;

import cn.iosd.starter.redisson.manager.RedissonManager;
import java.time.Duration;
import org.redisson.Redisson;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;

public class RedissonRateLimiterService {
    private final Redisson redisson;

    public RedissonRateLimiterService(RedissonManager redissonManager) {
        this.redisson = redissonManager.getRedisson();
    }

    public boolean tryAcquire(RateType type, String key, long rate, long rateTime, RateIntervalUnit timeUnit) {
        RRateLimiter rateLimiter = this.redisson.getRateLimiter(key);
        rateLimiter.trySetRate(type, rate, rateTime, timeUnit);
        rateLimiter.expireAsync(Duration.ofMillis(timeUnit.toMillis(rateTime)));
        return rateLimiter.tryAcquire();
    }
}

