/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.config.tactic.impl;

import cn.iosd.starter.redisson.config.tactic.RedissonConfigService;
import cn.iosd.starter.redisson.properties.RedissonProperties;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSlaveConfigImpl
implements RedissonConfigService {
    private static final Logger log = LoggerFactory.getLogger(MasterSlaveConfigImpl.class);

    @Override
    public Config createRedissonConfig(RedissonProperties properties) {
        Config config = new Config();
        List<String> slaveAddresses = properties.getMasterSlaveConfig().getSlaveAddresses();
        String masterAddress = properties.getMasterSlaveConfig().getMasterAddress();
        String password = properties.getMasterSlaveConfig().getPassword();
        MasterSlaveServersConfig masterSlaveConfig = config.useMasterSlaveServers().setMasterAddress(masterAddress).setDatabase(properties.getMasterSlaveConfig().getDatabase()).addSlaveAddress((String[])slaveAddresses.toArray(String[]::new));
        if (StringUtils.isNotBlank((CharSequence)password)) {
            masterSlaveConfig.setPassword(password);
        }
        log.info("\u521d\u59cb\u5316[\u4e3b\u4ece\u90e8\u7f72]\u65b9\u5f0f \u8fde\u63a5\u5730\u5740: \u4e3b\u8282\u70b9 {}, \u4ece\u8282\u70b9 {}", (Object)masterAddress, slaveAddresses);
        return config;
    }
}

