/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.utils;

import cn.iosd.starter.redisson.domain.MethodContext;
import cn.iosd.starter.redisson.utils.SpElUtil;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;

public class KeyUtil {
    private static final Logger log = LoggerFactory.getLogger(KeyUtil.class);
    private static final String STATIC_ABSENT_DEFAULT_VALUE = "SDV";
    private static final String PARAM_ABSENT_DEFAULT_VALUE = "PDV";

    public static String generate(ProceedingJoinPoint point, String value, String param, boolean includePointMd5) {
        MethodContext context = SpElUtil.getArgMap(point);
        String staticPart = StringUtils.isEmpty((CharSequence)value) ? STATIC_ABSENT_DEFAULT_VALUE : value;
        String dynamicPart = SpElUtil.analytical(param, context.argMap(), PARAM_ABSENT_DEFAULT_VALUE);
        String key = staticPart + ":" + dynamicPart;
        if (includePointMd5) {
            Supplier<String> md5 = () -> DigestUtils.md5DigestAsHex((byte[])context.toString().getBytes());
            return key + ":" + md5.get();
        }
        if (STATIC_ABSENT_DEFAULT_VALUE.equals(staticPart) && PARAM_ABSENT_DEFAULT_VALUE.equals(dynamicPart)) {
            log.error("Please verify that both the static part and the dynamic part yield empty values.The current default return value is set to [{}]", (Object)key);
        }
        return key;
    }
}

