/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.handler;

import cn.iosd.starter.redisson.annotation.DistributedLock;
import cn.iosd.starter.redisson.exception.RedissonException;
import cn.iosd.starter.redisson.service.RedissonLockService;
import cn.iosd.starter.redisson.utils.KeyUtil;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(prefix="simple.redisson", name={"enabled"}, havingValue="true")
public class DistributedLockHandler {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockHandler.class);
    @Autowired
    RedissonLockService redissonLockService;

    @Around(value="@annotation(distributedLock)")
    public Object around(ProceedingJoinPoint joinPoint, DistributedLock distributedLock) throws Throwable {
        String key = KeyUtil.generate(joinPoint, distributedLock.value(), distributedLock.param(), distributedLock.includePointMd5());
        int leaseTime = distributedLock.leaseTime();
        RLock lock = this.redissonLockService.getLock(key);
        log.debug("DistributedLock\uff0ckey[{}]", (Object)key);
        try {
            if (!lock.tryLock((long)leaseTime, TimeUnit.SECONDS)) {
                throw new RedissonException("\u83b7\u53d6Redis\u5206\u5e03\u5f0f\u9501[" + key + "]\u5931\u8d25");
            }
            Object object = joinPoint.proceed();
            return object;
        }
        catch (InterruptedException e) {
            throw new RedissonException("Redis\u5206\u5e03\u5f0f\u52a0\u9501[" + key + "]\u5931\u8d25", e);
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }
}

