/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.config.tactic.impl;

import cn.iosd.starter.redisson.config.tactic.RedissonConfigService;
import cn.iosd.starter.redisson.properties.RedissonProperties;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentinelConfigImpl
implements RedissonConfigService {
    private static final Logger log = LoggerFactory.getLogger(SentinelConfigImpl.class);

    @Override
    public Config createRedissonConfig(RedissonProperties properties) {
        Config config = new Config();
        List<String> sentinelAddresses = properties.getSentinelConfig().getSentinelAddresses();
        String password = properties.getSentinelConfig().getPassword();
        SentinelServersConfig sentinelConfig = config.useSentinelServers().setMasterName(properties.getSentinelConfig().getSentinelMasterName()).setDatabase(properties.getSentinelConfig().getDatabase()).addSentinelAddress((String[])sentinelAddresses.toArray(String[]::new));
        if (StringUtils.isNotBlank((CharSequence)password)) {
            sentinelConfig.setPassword(password);
        }
        log.info("\u521d\u59cb\u5316[\u54e8\u5175\u90e8\u7f72]\u65b9\u5f0f \u8fde\u63a5\u5730\u5740: {}", sentinelAddresses);
        return config;
    }
}

