/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.config;

import cn.iosd.starter.redisson.config.tactic.RedissonConfigService;
import cn.iosd.starter.redisson.config.tactic.impl.ClusterConfigImpl;
import cn.iosd.starter.redisson.config.tactic.impl.MasterSlaveConfigImpl;
import cn.iosd.starter.redisson.config.tactic.impl.SentinelConfigImpl;
import cn.iosd.starter.redisson.config.tactic.impl.StandaloneConfigImpl;
import cn.iosd.starter.redisson.exception.RedissonException;
import cn.iosd.starter.redisson.properties.RedissonProperties;
import org.redisson.config.Config;

public class RedissonConfigFactory {
    public static RedissonConfigFactory getInstance() {
        return RedissonConfigFactoryHolder.INSTANCE;
    }

    public Config createConfig(RedissonProperties redissonProperties) {
        String connectionType;
        RedissonConfigService redissonConfigService = switch (connectionType = redissonProperties.getType()) {
            case "standalone" -> new StandaloneConfigImpl();
            case "sentinel" -> new SentinelConfigImpl();
            case "cluster" -> new ClusterConfigImpl();
            case "masterSlave" -> new MasterSlaveConfigImpl();
            default -> throw new RedissonException("\u521b\u5efaRedisson\u8fde\u63a5Config\u5931\u8d25\uff01\u5f53\u524d\u8fde\u63a5\u65b9\u5f0f:" + connectionType);
        };
        return redissonConfigService.createRedissonConfig(redissonProperties);
    }

    private static class RedissonConfigFactoryHolder {
        private static final RedissonConfigFactory INSTANCE = new RedissonConfigFactory();

        private RedissonConfigFactoryHolder() {
        }
    }
}

