/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpElUtil {
    private static final Map<String, Expression> CACHE = new ConcurrentHashMap<String, Expression>();
    private static final ExpressionParser PARSER = new SpelExpressionParser();

    public static <T> T analytical(String spEl, Map<String, Object> argMap, Class<T> clazz, T defaultValue) {
        if (!spEl.contains("#")) {
            return defaultValue;
        }
        Expression expression = CACHE.get(spEl);
        StandardEvaluationContext context = new StandardEvaluationContext(argMap);
        for (Map.Entry<String, Object> entry : argMap.entrySet()) {
            context.setVariable(entry.getKey(), entry.getValue());
        }
        if (expression == null) {
            expression = PARSER.parseExpression(spEl);
            CACHE.putIfAbsent(spEl, expression);
        }
        return (T)SpElUtil.defVal(expression.getValue((EvaluationContext)context, clazz), defaultValue);
    }

    static <T> T defVal(T val, T defVal) {
        return val == null ? defVal : val;
    }

    public static Map<String, Object> getArgMap(ProceedingJoinPoint point) {
        Object[] args = point.getArgs();
        HashMap<String, Object> map = new HashMap<String, Object>(args.length + 1);
        StandardReflectionParameterNameDiscoverer discoverer = new StandardReflectionParameterNameDiscoverer();
        Method method = ((MethodSignature)point.getSignature()).getMethod();
        String[] params = discoverer.getParameterNames(method);
        if (params != null) {
            for (int len = 0; len < params.length; ++len) {
                map.put(params[len], args[len]);
            }
        }
        map.put("RedissonMethodName", method.getName());
        return map;
    }
}

