/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.service.impl;

import cn.iosd.starter.redisson.properties.RedissonProperties;
import cn.iosd.starter.redisson.service.RedissonConfigService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSlaveConfigImpl
implements RedissonConfigService {
    private static final Logger log = LoggerFactory.getLogger(MasterSlaveConfigImpl.class);

    @Override
    public Config createRedissonConfig(RedissonProperties redissonProperties) {
        Config config = new Config();
        String address = redissonProperties.getAddress();
        String password = redissonProperties.getPassword();
        Integer database = redissonProperties.getDatabase();
        String[] addrTokens = address.split(",");
        String masterNodeAddr = addrTokens[0];
        config.useMasterSlaveServers().setMasterAddress(masterNodeAddr);
        if (StringUtils.isNotBlank((CharSequence)password)) {
            config.useMasterSlaveServers().setPassword(password);
        }
        config.useMasterSlaveServers().setDatabase(database.intValue());
        ArrayList<CallSite> slaveList = new ArrayList<CallSite>();
        for (String addrToken : addrTokens) {
            slaveList.add((CallSite)((Object)("redis://" + addrToken)));
        }
        slaveList.remove(0);
        String[] applyIdStr = slaveList.toArray(new String[slaveList.size()]);
        config.useMasterSlaveServers().addSlaveAddress(applyIdStr);
        log.info("\u521d\u59cb\u5316[\u4e3b\u4ece\u90e8\u7f72]\u65b9\u5f0f \u8fde\u63a5\u5730\u5740:" + address);
        return config;
    }
}

