/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.config;

import cn.iosd.starter.redisson.properties.RedissonProperties;
import cn.iosd.starter.redisson.service.RedissonCacheService;
import cn.iosd.starter.redisson.service.RedissonLockService;
import cn.iosd.starter.redisson.service.RedissonManager;
import org.redisson.Redisson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnClass(value={Redisson.class})
@ConditionalOnProperty(prefix="simple.redisson", name={"enabled"}, havingValue="true")
public class RedissonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedissonAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @Order(value=2)
    public RedissonLockService redissonLock(RedissonManager redissonManager) {
        return new RedissonLockService(redissonManager);
    }

    @Bean
    @ConditionalOnMissingBean
    @Order(value=2)
    public RedissonCacheService redissonCache(RedissonManager redissonManager) {
        return new RedissonCacheService(redissonManager);
    }

    @Bean
    @ConditionalOnMissingBean
    @Order(value=1)
    public RedissonManager redissonManager(RedissonProperties redissonProperties) {
        log.info("[RedissonManager]\u7ec4\u88c5\u5b8c\u6bd5,\u5f53\u524d\u8fde\u63a5\u65b9\u5f0f:" + redissonProperties.getType() + ",\u8fde\u63a5\u5730\u5740:" + redissonProperties.getAddress());
        return new RedissonManager(redissonProperties);
    }
}

