/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.service.impl;

import cn.iosd.starter.redisson.constant.RedisConnectionUrl;
import cn.iosd.starter.redisson.properties.RedissonProperties;
import cn.iosd.starter.redisson.service.RedissonConfigService;
import org.apache.commons.lang3.StringUtils;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentinelConfigImpl
implements RedissonConfigService {
    private static final Logger log = LoggerFactory.getLogger(SentinelConfigImpl.class);

    @Override
    public Config createRedissonConfig(RedissonProperties redissonProperties) {
        Config config = new Config();
        try {
            String address = redissonProperties.getAddress();
            String password = redissonProperties.getPassword();
            Integer database = redissonProperties.getDatabase();
            String[] addrTokens = address.split(",");
            String sentinelAliasName = addrTokens[0];
            config.useSentinelServers().setMasterName(sentinelAliasName);
            config.useSentinelServers().setDatabase(database.intValue());
            if (StringUtils.isNotBlank((CharSequence)password)) {
                config.useSentinelServers().setPassword(password);
            }
            for (int i = 1; i < addrTokens.length; ++i) {
                config.useSentinelServers().addSentinelAddress(new String[]{RedisConnectionUrl.REDIS_CONNECTION_PREFIX.getValue() + addrTokens[i]});
            }
            log.info("\u521d\u59cb\u5316[\u54e8\u5175\u90e8\u7f72]\u65b9\u5f0f \u8fde\u63a5\u5730\u5740:" + address);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316[\u54e8\u5175\u90e8\u7f72]\u65b9\u5f0f \u5f02\u5e38\uff1a", (Throwable)e);
        }
        return config;
    }
}

