/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.service;

import cn.iosd.starter.redisson.service.RedissonManager;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.api.RLock;

public class RedissonLockService {
    private Redisson redisson;

    public RedissonLockService(RedissonManager redissonManager) {
        this.redisson = redissonManager.getRedisson();
    }

    public void lock(String lockName, long leaseTime) {
        RLock rLock = this.redisson.getLock(lockName);
        rLock.lock(leaseTime, TimeUnit.SECONDS);
    }

    public void lock(String lockName) {
        RLock rLock = this.redisson.getLock(lockName);
        rLock.lock();
    }

    public boolean tryLock(String lockName, long leaseTime) {
        RLock rLock = this.redisson.getLock(lockName);
        boolean getLock = false;
        try {
            getLock = rLock.tryLock(leaseTime, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return getLock;
    }

    public boolean tryLock(String lockName, long leaseTime, long waitTime) {
        RLock rLock = this.redisson.getLock(lockName);
        boolean getLock = false;
        try {
            getLock = rLock.tryLock(waitTime, leaseTime, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return getLock;
    }

    public void unlock(String lockName) {
        this.redisson.getLock(lockName).unlock();
    }

    public boolean isLock(String lockName) {
        RLock rLock = this.redisson.getLock(lockName);
        return rLock.isLocked();
    }

    public boolean isHeldByCurrentThread(String lockName) {
        RLock rLock = this.redisson.getLock(lockName);
        return rLock.isHeldByCurrentThread();
    }

    public RLock getLock(String name) {
        return this.redisson.getLock(name);
    }
}

