/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.service;

import cn.iosd.starter.redisson.service.RedissonManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.api.RBucket;
import org.redisson.api.RList;
import org.redisson.api.RMap;

public class RedissonCacheService {
    private Redisson redisson;

    public RedissonCacheService(RedissonManager redissonManager) {
        this.redisson = redissonManager.getRedisson();
    }

    public void setObject(String key, Object value, long ttl) {
        RBucket bucket = this.redisson.getBucket(key);
        bucket.set(value, ttl, TimeUnit.SECONDS);
    }

    public void setObject(String key, Object value) {
        RBucket bucket = this.redisson.getBucket(key);
        bucket.set(value);
    }

    public <V> V getObject(String key) {
        RBucket bucket = this.redisson.getBucket(key);
        return (V)bucket.get();
    }

    public boolean existsObject(String key) {
        RBucket bucket = this.redisson.getBucket(key);
        return bucket.isExists();
    }

    public <V> void setList(String key, List<V> list, long ttl) {
        RList rList = this.redisson.getList(key);
        rList.addAll(list);
        rList.expire(ttl, TimeUnit.SECONDS);
    }

    public <V> void setList(String key, List<V> list) {
        RList rList = this.redisson.getList(key);
        rList.addAll(list);
    }

    public <V> List<V> getList(String key) {
        RList rList = this.redisson.getList(key);
        return rList.readAll();
    }

    public boolean existsList(String key) {
        RList rList = this.redisson.getList(key);
        return rList.isExists();
    }

    public <K, V> void setMap(String key, Map<K, V> map, long ttl) {
        RMap rMap = this.redisson.getMap(key);
        rMap.putAll(map);
        rMap.expire(ttl, TimeUnit.SECONDS);
    }

    public <K, V> void setMap(String key, Map<K, V> map) {
        RMap rMap = this.redisson.getMap(key);
        rMap.putAll(map);
    }

    public <K, V> Map<K, V> getMap(String key) {
        RMap rMap = this.redisson.getMap(key);
        return rMap.readAllMap();
    }

    public boolean existsMap(String key) {
        RMap rMap = this.redisson.getMap(key);
        return rMap.isExists();
    }

    public void delete(String key) {
        this.redisson.getBucket(key).delete();
    }
}

