/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.service;

import cn.iosd.starter.redisson.properties.RedissonProperties;
import cn.iosd.starter.redisson.service.impl.ClusterConfigImpl;
import cn.iosd.starter.redisson.service.impl.MasterSlaveConfigImpl;
import cn.iosd.starter.redisson.service.impl.SentinelConfigImpl;
import cn.iosd.starter.redisson.service.impl.StandaloneConfigImpl;
import org.redisson.Redisson;
import org.redisson.config.Config;

public class RedissonManager {
    private Config config;
    private Redisson redisson;

    public RedissonManager(RedissonProperties redissonProperties) {
        try {
            this.config = RedissonConfigFactory.getInstance().createConfig(redissonProperties);
            this.redisson = (Redisson)Redisson.create((Config)this.config);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Redisson init error. Please check the configuration");
        }
    }

    public Redisson getRedisson() {
        return this.redisson;
    }

    static class RedissonConfigFactory {
        private static volatile RedissonConfigFactory factory = null;

        private RedissonConfigFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static RedissonConfigFactory getInstance() {
            if (factory != null) return factory;
            Class<Object> clazz = Object.class;
            synchronized (Object.class) {
                if (factory != null) return factory;
                factory = new RedissonConfigFactory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return factory;
            }
        }

        Config createConfig(RedissonProperties redissonProperties) {
            String connectionType;
            return (switch (connectionType = redissonProperties.getType()) {
                case "standalone" -> new StandaloneConfigImpl();
                case "sentinel" -> new SentinelConfigImpl();
                case "cluster" -> new ClusterConfigImpl();
                case "masterSlave" -> new MasterSlaveConfigImpl();
                default -> throw new IllegalArgumentException("\u521b\u5efaRedisson\u8fde\u63a5Config\u5931\u8d25\uff01\u5f53\u524d\u8fde\u63a5\u65b9\u5f0f:" + connectionType);
            }).createRedissonConfig(redissonProperties);
        }
    }
}

