/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.annotation;

import cn.iosd.starter.redisson.annotation.DistributedLock;
import cn.iosd.starter.redisson.service.RedissonService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(prefix="simple.redisson", name={"enabled"}, havingValue="true")
public class DistributedLockHandler {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockHandler.class);
    @Autowired
    RedissonService redissonService;
    public static final String LOCK_NAME_APPEND = "RedissonLock:";

    @Around(value="@annotation(distributedLock)")
    public Object around(ProceedingJoinPoint joinPoint, DistributedLock distributedLock) throws Throwable {
        Object proceed;
        log.info("[\u5f00\u59cb]\u6267\u884cRedisLock\u73af\u7ed5\u901a\u77e5,\u83b7\u53d6Redis\u5206\u5e03\u5f0f\u9501\u5f00\u59cb");
        Object lockName = distributedLock.value();
        lockName = LOCK_NAME_APPEND + (String)lockName;
        int leaseTime = distributedLock.leaseTime();
        this.redissonService.lock((String)lockName, leaseTime);
        try {
            log.info("\u83b7\u53d6Redis\u5206\u5e03\u5f0f\u9501[\u6210\u529f]\uff0c\u52a0\u9501\u5b8c\u6210\uff0c\u5f00\u59cb\u6267\u884c\u4e1a\u52a1\u903b\u8f91...");
            proceed = joinPoint.proceed();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (this.redissonService.isHeldByCurrentThread((String)lockName)) {
                this.redissonService.unlock((String)lockName);
            }
            log.info("\u91ca\u653eRedis\u5206\u5e03\u5f0f\u9501[\u6210\u529f]\uff0c\u89e3\u9501\u5b8c\u6210\uff0c\u7ed3\u675f\u4e1a\u52a1\u903b\u8f91...");
        }
        return proceed;
    }
}

