/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.annotation;

import cn.iosd.starter.redisson.annotation.DistributedIdempotent;
import cn.iosd.starter.redisson.service.RedissonService;
import cn.iosd.starter.redisson.utils.SpElUtil;
import java.util.Map;
import java.util.function.Supplier;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

@Aspect
@Component
@ConditionalOnProperty(prefix="simple.redisson", name={"enabled"}, havingValue="true")
public class DistributedIdempotentHandler {
    private static final Logger log = LoggerFactory.getLogger(DistributedIdempotentHandler.class);
    private static final String LOCK_KEY_PREFIX = "RedissonIdempotent:";
    @Autowired
    RedissonService redissonService;

    @Around(value="@annotation(cn.iosd.starter.redisson.annotation.DistributedIdempotent)||@within(cn.iosd.starter.redisson.annotation.DistributedIdempotent)")
    public Object idempotent(ProceedingJoinPoint point) throws Throwable {
        log.info("[\u5f00\u59cb]\u6267\u884cDistributedIdempotent\u73af\u7ed5\u901a\u77e5");
        DistributedIdempotent idempotent = ((MethodSignature)point.getSignature()).getMethod().getAnnotation(DistributedIdempotent.class);
        Map<String, Object> argMap = SpElUtil.getArgMap(point);
        Supplier<String> md5Supplier = () -> DigestUtils.md5DigestAsHex((byte[])argMap.toString().getBytes());
        String lockName = DistributedIdempotentHandler.getLockName(argMap, md5Supplier, idempotent.value());
        RLock lock = this.redissonService.getLock(LOCK_KEY_PREFIX.concat(lockName));
        if (lock.isLocked()) {
            throw new Exception(idempotent.message());
        }
        if (lock.tryLock(idempotent.acquireTimeout(), idempotent.expireTime(), idempotent.unit())) {
            Object proceed;
            log.info("\u6267\u884cRedis\u5e42\u7b49\u5207\u9762[\u6210\u529f]\uff0c\u52a0\u9501\u5b8c\u6210\uff0c\u5f00\u59cb\u6267\u884c\u4e1a\u52a1\u903b\u8f91...");
            try {
                proceed = point.proceed();
            }
            catch (Throwable throwable) {
                lock.unlock();
                throw throwable;
            }
            log.info("[\u5b8c\u6210]\u6267\u884cDistributedIdempotent\u73af\u7ed5\u901a\u77e5");
            return proceed;
        }
        throw new Exception(idempotent.message());
    }

    private static String getLockName(Map<String, Object> argMap, Supplier<String> md5, String spEl) {
        String methodName = argMap.get("RedissonMethodName").toString();
        if (spEl.equals("RedissonMethodName")) {
            return methodName + md5.get();
        }
        return SpElUtil.analytical(spEl, argMap, String.class, methodName) + md5.get();
    }
}

