/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.service;

import cn.iosd.starter.redisson.properties.RedissonProperties;
import cn.iosd.starter.redisson.service.RedissonConfigService;
import cn.iosd.starter.redisson.service.impl.ClusterConfigImpl;
import cn.iosd.starter.redisson.service.impl.MasterSlaveConfigImpl;
import cn.iosd.starter.redisson.service.impl.SentinelConfigImpl;
import cn.iosd.starter.redisson.service.impl.StandaloneConfigImpl;
import org.redisson.config.Config;

public class RedissonConfigFactory {
    public static RedissonConfigFactory getInstance() {
        return RedissonConfigFactoryHolder.INSTANCE;
    }

    public Config createConfig(RedissonProperties redissonProperties) {
        RedissonConfigService redissonConfigService;
        String connectionType;
        switch (connectionType = redissonProperties.getType()) {
            case "standalone": {
                redissonConfigService = new StandaloneConfigImpl();
                break;
            }
            case "sentinel": {
                redissonConfigService = new SentinelConfigImpl();
                break;
            }
            case "cluster": {
                redissonConfigService = new ClusterConfigImpl();
                break;
            }
            case "masterSlave": {
                redissonConfigService = new MasterSlaveConfigImpl();
                break;
            }
            default: {
                throw new IllegalArgumentException("\u521b\u5efaRedisson\u8fde\u63a5Config\u5931\u8d25\uff01\u5f53\u524d\u8fde\u63a5\u65b9\u5f0f:" + connectionType);
            }
        }
        return redissonConfigService.createRedissonConfig(redissonProperties);
    }

    private static class RedissonConfigFactoryHolder {
        private static final RedissonConfigFactory INSTANCE = new RedissonConfigFactory();

        private RedissonConfigFactoryHolder() {
        }
    }
}

