/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.redisson.service;

import cn.iosd.starter.redisson.properties.RedissonCacheableProperties;
import cn.iosd.starter.redisson.service.RedissonManager;
import java.util.HashMap;
import org.redisson.api.RedissonClient;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.RedissonSpringCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;

@EnableCaching
@ConditionalOnProperty(value={"simple.redisson.cacheable.enabled", "simple.redisson.enabled"}, havingValue="true")
public class RedissonCacheableManager {
    private static final Logger log = LoggerFactory.getLogger(RedissonCacheableManager.class);
    @Autowired
    private RedissonCacheableProperties properties;
    @Autowired(required=false)
    private RedissonManager redissonManager;

    @Bean
    public CacheManager cacheManager() {
        HashMap<String, CacheConfig> config = new HashMap<String, CacheConfig>(3);
        config.put("cacheExpiresAfterTenMinutes", new CacheConfig(600000L, 600000L));
        config.put("cacheExpiresAfterOneHour", new CacheConfig(3600000L, 3600000L));
        config.put("cacheNeverExpires", new CacheConfig());
        log.info("Cacheable\u9ed8\u8ba4CacheName\u914d\u7f6e\u7c7b\u5df2\u88c5\u914d\uff1a[cacheNeverExpires,cacheExpiresAfterTenMinutes,cacheExpiresAfterOneHour]");
        if (this.properties.getConfig() != null) {
            this.properties.getConfig().forEach((cacheName, cacheExpireVo) -> {
                Long ttl = cacheExpireVo.getTtl();
                Long maxIdleTime = cacheExpireVo.getMaxIdleTime();
                CacheConfig cacheConfig = new CacheConfig(ttl.longValue(), maxIdleTime.longValue());
                config.put((String)cacheName, cacheConfig);
                log.info("Cacheable\u81ea\u5b9a\u4e49CacheName\u914d\u7f6e\u7c7b\u5df2\u88c5\u914d\uff0cCacheName\uff1a{}, ttl:{}\u6beb\u79d2, maxIdleTime:{}\u6beb\u79d2", new Object[]{cacheName, ttl, maxIdleTime});
            });
        }
        return new RedissonSpringCacheManager((RedissonClient)this.redissonManager.getRedisson(), config);
    }
}

