/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.grpc.client;

import cn.iosd.starter.grpc.client.annotation.GrpcClient;
import cn.iosd.starter.grpc.client.vo.GrpcClientBean;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class InitializeGrpcClientBeans
implements BeanPostProcessor {
    private final List<GrpcClientBean> injections = new ArrayList<GrpcClientBean>();

    public List<GrpcClientBean> getInjections() {
        return this.injections;
    }

    public Object postProcessAfterInitialization(@Nullable Object bean, @Nullable String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(@Nullable Object bean, @Nullable String beanName) throws BeansException {
        if (bean == null) {
            return null;
        }
        Stream.of(bean.getClass().getDeclaredFields()).filter(field -> field.isAnnotationPresent(GrpcClient.class)).forEach(field -> {
            GrpcClient annotation = field.getAnnotation(GrpcClient.class);
            GrpcClientBean registry = new GrpcClientBean(bean, annotation, (Field)field);
            this.injections.add(registry);
        });
        return bean;
    }
}

