/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.grpc.server;

import cn.iosd.starter.grpc.server.interceptor.CustomServerInterceptor;
import cn.iosd.starter.grpc.server.interceptor.ServiceCallStartHeaders;
import cn.iosd.starter.grpc.server.properties.GrpcServerProperties;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GrpcServerService {
    private static final Logger log = LoggerFactory.getLogger(GrpcServerService.class);
    @Autowired
    private GrpcServerProperties grpcServerProperties;
    @Autowired(required=false)
    private ServiceCallStartHeaders serviceCallStartHeaders;
    @Autowired(required=false)
    private List<BindableService> grpcServices;
    private Server server;

    @PostConstruct
    public void startGrpcServer() throws IOException {
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)this.grpcServerProperties.getPort());
        if (this.grpcServices != null && !this.grpcServices.isEmpty()) {
            this.grpcServices.forEach(service -> {
                serverBuilder.addService(service);
                log.info("GrpcServer add service: {}", (Object)service.getClass().getName());
            });
        } else {
            log.warn("No GrpcService found to add to the server");
        }
        CustomServerInterceptor customServerInterceptor = new CustomServerInterceptor(this.serviceCallStartHeaders);
        serverBuilder.intercept((ServerInterceptor)customServerInterceptor);
        this.server = serverBuilder.build();
        this.server.start();
        log.info("GrpcServer start port: {}", (Object)this.grpcServerProperties.getPort());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.server.shutdown();
            log.info("GrpcServer shut down");
        }));
    }
}

