/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.grpc.client;

import cn.iosd.starter.grpc.client.InitializeGrpcClientBeans;
import cn.iosd.starter.grpc.client.annotation.GrpcClient;
import cn.iosd.starter.grpc.client.interceptor.ClientCallStartHeaders;
import cn.iosd.starter.grpc.client.properties.GrpcChannelProperties;
import cn.iosd.starter.grpc.client.properties.GrpcClientProperties;
import cn.iosd.starter.grpc.client.vo.GrpcChannel;
import cn.iosd.starter.grpc.client.vo.GrpcClientBeans;
import io.grpc.ManagedChannel;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

@Configuration
public class GrpcClientService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(GrpcClientService.class);
    @Autowired
    private GrpcClientProperties grpcClientProperties;
    @Autowired
    private InitializeGrpcClientBeans beanInjection;
    @Autowired(required=false)
    private List<ClientCallStartHeaders> clientCallStartHeadersList;

    public void afterPropertiesSet() {
        Optional.ofNullable(this.beanInjection).map(InitializeGrpcClientBeans::getGrpcClientBeans).map(GrpcClientBeans::getInjections).ifPresent(this::initializeGrpcClients);
    }

    private void initializeGrpcClients(List<GrpcClientBeans.GrpcClientBean> grpcClientBeanList) {
        grpcClientBeanList.forEach(this::configureGrpcClientBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureGrpcClientBean(GrpcClientBeans.GrpcClientBean grpcClientBean) {
        GrpcClient annotation = grpcClientBean.client();
        String annotationValue = annotation.value();
        Optional<GrpcChannelProperties> channelPropertiesOpt = Optional.ofNullable(this.grpcClientProperties.getChannel()).map(channel -> (GrpcChannelProperties)channel.get(annotationValue));
        if (channelPropertiesOpt.isEmpty()) {
            log.error("\u914d\u7f6e\u6587\u4ef6\u7f3a\u5931\u8bf7\u6838\u67e5\uff0cGrpcChannel\u672a\u88c5\u914d\u503c\uff1a{}", (Object)annotationValue);
            return;
        }
        Class<?> type = grpcClientBean.field().getType();
        Field field = grpcClientBean.field();
        Object bean = grpcClientBean.bean();
        long timeout = this.getTimeout(annotation);
        ClientCallStartHeaders headers = this.getHeaders(annotation);
        GrpcChannelProperties properties = this.grpcClientProperties.getChannel().get(annotationValue);
        ManagedChannel client = GrpcChannel.getChannel(properties.getAddress(), timeout, headers);
        Object object = GrpcChannel.getBlockingStub(client, type);
        boolean accessible = field.canAccess(bean);
        ReflectionUtils.makeAccessible((Field)field);
        try {
            field.set(bean, object);
            log.info("\u5b8c\u6210 {} \u7684 GrpcChannel \u88c5\u914d;\u8c03\u7528\u8d85\u65f6\u65f6\u95f4\u4e3a {} \u6beb\u79d2;headers\u4e3a {}", new Object[]{annotationValue, timeout, headers});
        }
        catch (IllegalAccessException e) {
            log.error("\u5bf9\u8c61 {} \u6ce8\u5165\u914d\u7f6e GrpcChannel \u5f02\u5e38\uff1a", (Object)bean.getClass().getSimpleName(), (Object)e);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    private long getTimeout(GrpcClient annotation) {
        return annotation.timeout() != -1L ? annotation.timeout() : this.grpcClientProperties.getTimeout().longValue();
    }

    private ClientCallStartHeaders getHeaders(GrpcClient annotation) {
        if (CollectionUtils.isEmpty(this.clientCallStartHeadersList)) {
            return null;
        }
        if (this.clientCallStartHeadersList.size() == 1 && annotation.headerClass().equals(ClientCallStartHeaders.class)) {
            return this.clientCallStartHeadersList.get(0);
        }
        if (!annotation.headerClass().equals(ClientCallStartHeaders.class)) {
            return this.clientCallStartHeadersList.stream().filter(header -> annotation.headerClass().isInstance(header)).findFirst().orElse(null);
        }
        return null;
    }
}

