/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.grpc.client.interceptor;

import cn.iosd.starter.grpc.client.interceptor.ClientCallStartHeaders;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CustomClientInterceptor
implements ClientInterceptor {
    private final long timeout;
    private final TimeUnit timeUnit;
    private final ClientCallStartHeaders clientCallStartHeaders;

    public CustomClientInterceptor(long timeout, TimeUnit timeUnit, ClientCallStartHeaders headers) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.clientCallStartHeaders = headers;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel channel) {
        CallOptions newCallOptions = callOptions.withDeadlineAfter(this.timeout, this.timeUnit);
        if (this.clientCallStartHeaders == null || this.clientCallStartHeaders.headers().isEmpty()) {
            return channel.newCall(method, newCallOptions);
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(channel.newCall(method, newCallOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                Map<String, String> map = CustomClientInterceptor.this.clientCallStartHeaders.headers();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    headers.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
                }
                super.start(responseListener, headers);
            }
        };
    }
}

