/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.grpc.client;

import cn.iosd.starter.grpc.client.InitializeGrpcClientBeans;
import cn.iosd.starter.grpc.client.annotation.GrpcClient;
import cn.iosd.starter.grpc.client.interceptor.ClientCallStartHeaders;
import cn.iosd.starter.grpc.client.properties.GrpcChannelProperties;
import cn.iosd.starter.grpc.client.properties.GrpcClientProperties;
import cn.iosd.starter.grpc.client.vo.GrpcChannel;
import cn.iosd.starter.grpc.client.vo.GrpcClientBeans;
import io.grpc.ManagedChannel;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

@Configuration
public class GrpcClientService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(GrpcClientService.class);
    @Autowired
    private GrpcClientProperties grpcClientProperties;
    @Autowired
    private InitializeGrpcClientBeans beanInjection;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private List<ClientCallStartHeaders> clientCallStartHeadersList;
    private Map<String, ClientCallStartHeaders> clientCallStartHeadersMap = new HashMap<String, ClientCallStartHeaders>();

    @PostConstruct
    public void init() {
        if (CollectionUtils.isEmpty(this.clientCallStartHeadersList)) {
            return;
        }
        for (ClientCallStartHeaders service : this.clientCallStartHeadersList) {
            String beanName = this.applicationContext.getBeanNamesForType(service.getClass())[0];
            this.clientCallStartHeadersMap.put(beanName, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        if (this.beanInjection == null || this.beanInjection.getGrpcClientBeans() == null) {
            return;
        }
        GrpcClientBeans grpcClientBeans = this.beanInjection.getGrpcClientBeans();
        List<GrpcClientBeans.GrpcClientBean> grpcClientBeanList = grpcClientBeans.getInjections();
        for (GrpcClientBeans.GrpcClientBean grpcClientBean : grpcClientBeanList) {
            GrpcClient annotation = grpcClientBean.client();
            Class<?> type = grpcClientBean.field().getType();
            Field field = grpcClientBean.field();
            Object bean = grpcClientBean.bean();
            if (this.grpcClientProperties.getChannel() == null || this.grpcClientProperties.getChannel().get(annotation.value()) == null) {
                log.error("\u914d\u7f6e\u6587\u4ef6\u7f3a\u5931\u8bf7\u6838\u67e5\uff0cGrpcChannel\u672a\u88c5\u914d\u503c\uff1a{}", (Object)annotation.value());
                continue;
            }
            GrpcChannelProperties properties = this.grpcClientProperties.getChannel().get(annotation.value());
            long timeout = -1L != annotation.timeout() ? annotation.timeout() : this.grpcClientProperties.getTimeout().longValue();
            ClientCallStartHeaders headers = null;
            if (!CollectionUtils.isEmpty(this.clientCallStartHeadersList)) {
                String beanName;
                headers = this.clientCallStartHeadersList.size() == 1 && StringUtils.isBlank((CharSequence)annotation.headerBeanName()) ? this.clientCallStartHeadersList.get(0) : (StringUtils.isNotBlank((CharSequence)(beanName = annotation.headerBeanName())) ? this.clientCallStartHeadersMap.get(beanName) : null);
            }
            ManagedChannel client = GrpcChannel.getChannel(properties.getAddress(), timeout, headers);
            Object object = GrpcChannel.getBlockingStub(client, type);
            boolean accessible = field.canAccess(bean);
            ReflectionUtils.makeAccessible((Field)field);
            try {
                field.set(bean, object);
                log.info("\u5b8c\u6210 {} \u7684 GrpcChannel \u88c5\u914d;\u8c03\u7528\u8d85\u65f6\u65f6\u95f4\u4e3a {} \u6beb\u79d2;headers\u4e3a {}", new Object[]{annotation.value(), timeout, headers});
            }
            catch (IllegalAccessException e) {
                String message = String.format("\u5bf9\u8c61 %s \u6ce8\u5165\u914d\u7f6e GrpcChannel \u5f02\u5e38\uff1a", bean.getClass().getSimpleName());
                log.error(message, (Throwable)e);
            }
            finally {
                field.setAccessible(accessible);
            }
        }
    }
}

